<?php

namespace Mnv\Models;

use Mnv\Core\DB;
use Mnv\Core\Mnv;
use PHPMailer\PHPMailer\SMTP;

/**
 * Class Settings
 * @package Mnv\Models
 */
class Settings extends Mnv
{

    private static $_table = 'settings';
    private static $_table_stats_visitors = 'stats_visitors';
    private static $table_stats_visits    = 'stats_visits';
    protected $visitsByType = array();
    protected $settings;
    protected $date;

    public function clearCache()
    {
        $this->smarty->clearAllCache();
    }

    public function get()
    {
       return DB::init()->connect()->table('settings')->select('codename, value')->indexKey('codename')->valueKey('value')->getAllIndexes();
    }


    /**
     * @param $settings
     * @return bool
     */
    public function save($settings)
    {
        global $tbl;

        $thumbSizeNames = array('small_thumb', 'medium_thumb', 'large_thumb');

        if (!empty($settings['old_site_url'])) {

            DB::init()->connect()->query("UPDATE  `$tbl[sections]`  SET  `url` = replace(url, '$settings[old_site_url]', '$settings[site_url]') ")->exec();
            DB::init()->connect()->query("UPDATE  `$tbl[articles]`  SET  `url` = replace(url, '$settings[old_site_url]', '$settings[site_url]') ")->exec();
        }

        //old $settings += dbRawQuery("SHOW VARIABLES LIKE 'ft_min_word_len'", 'Variable_name', 'Value');

        foreach ($settings as $codename => $value) if (!isset($this->config[$codename]) || $this->config[$codename] != $value) {

                if (in_array($codename, $thumbSizeNames)) $value = (int) $value;

                switch ($codename) {
                case 'compress_js_css':
//                    $updateHtaccess = true;
                    break;

                /* control panel language has changed */
                case 'admin_language':
                    $adminLang = $value;
                    loadLanguage($adminLang);
                    $this->smarty->setCompileId('admin-'.$adminLang);
                    $this->smarty->assign('adminLang', $adminLang);
                    break;

                /* file extension has been changed */
                case 'file_extension':
//                    $updateHtaccess = true;
                    $oldExtension = $this->config['file_extension'];

                    /* update all article and sections URLs */
                        DB::init()->connect()->query("UPDATE  `$tbl[articles]` SET  `url` = CONCAT(LEFT(`url`, CHAR_LENGTH(url)-CHAR_LENGTH('$oldExtension')), '$settings[file_extension]') WHERE  `url` LIKE '%.$oldExtension'")->exec();
                        DB::init()->connect()->query("UPDATE  `$tbl[sections]` SET  `url` = CONCAT(LEFT(`url`, CHAR_LENGTH(url)-CHAR_LENGTH('$oldExtension')), '$settings[file_extension]') WHERE  `url` LIKE '%.$oldExtension'")->exec();

                    break;

                case 'bot_id_strings':
                    if ($bots = explode("\r\n", $value)) {
                        $bots = array_map('trim', $bots);
                        $bots = array_preg_quote($bots);
                        $bots = implode('|', $bots);
                    } else {
                        $bots = '';
                    }
                    $setting['codename'] = 'bot_id_regexp';
                    $setting['value'] = $bots;
                    DB::init()->connect()->table(static::$_table)->replace($setting);
                    DB::init()->connect()->query("UPDATE  `$tbl[stats_user_agents]` SET  `isBot` = IF(userAgent RLIKE '".$bots."', 1, 0)")->exec();

                case 'bot_id_regexp':
                case 'query_fields_strings':
                    if ($queryFields = explode("\r\n", $value)) {
                        $queryFields = array_map('trim', $queryFields);
                        $queryFields = array_preg_quote($queryFields);
                        $queryFields = implode('|', $queryFields);
                    } else {
                        $queryFields = '';
                    }
                    $setting['codename'] = 'query_fields';
                    $setting['value'] = $queryFields;

                    DB::init()->connect()->table(static::$_table)->replace($setting);
                case 'theme':
                    /* theme has been changed */
                    $this->smarty->clearAllCache();
                    break;
            }

            $setting['codename'] = $codename;
            $setting['value'] =  $value;

            DB::init()->connect()->table(static::$_table)->replace($setting);
        }

        return true;
    }


    /**
     * TODO: доработать удаление статистики
     * @param $date
     */
    public function deleteStatsPriorTo($date)
    {
        global $tbl;

        $type2table = array(
            2  => 'stats_section_visits',
            3  => 'stats_article_visits',
            4  => 'stats_search_visits',
            5  => 'stats_ad_clicks',
            6  => 'stats_error_visits',
            7  => 'stats_rss_visits'
        );

        $date = date("Y-m-d", strtotime($date));

        do {
            if ($visitorsArr = DB::init()->connect()->table('stats_visitors')->select('visitorId')->where('firstVisitOn', '<', $date)->limit(1000)->getAll()) {
                foreach ($visitorsArr as $visitor) $visitors[$visitor->visitorId] = $visitor;

                do {
                    if ($visitsArr = DB::init()->connect()->table(static::$table_stats_visits)->select('visitId, typeId')->in('visitorId', array_keys($visitors))->limit(1000)->getAll()) {
                    foreach ($visitsArr as $visit) $visits[$visit->visitId] = $visit->typeId;

                        foreach ($visits as $visitId => $typeId) {
                            if (!isset($this->visitsByType[$typeId])) $this->visitsByType[$typeId] = array();
                            $this->visitsByType[$typeId][] = $visitId;
                        }
                        /* deleting each type of visit */
                        foreach($this->visitsByType as $typeId => $typeVisits) if (!empty($tbl[$type2table[$typeId]])) {

                            DB::init()->connect()->table($type2table[$typeId])->in('visitId', $typeVisits)->delete();
                        }

                        /* deleting all visits */
                        DB::init()->connect()->table(static::$table_stats_visits)->in('visitId', array_keys($visits))->delete();
                    }
                } while (!empty($visitsArr));

                /* deleting visitors */
                DB::init()->connect()->table(static::$_table_stats_visitors)->in('visitorId', array_keys($visitors))->delete();
            }
        } while (!empty($visitorsArr));
    }


    /**
     * Тестировать подключение SMTP
     * @param $port
     * @param $host
     * @param $username
     * @param $password
     * @return array
     */
    public function testSMTP($port, $host, $username, $password): array
    {

        $result   = [
            'status'  => false,
            'message' => '',
            'trace'   => '',
        ];
        if ($port == 465) {
            // Добавляем протокол, если не указали
            $host = (strpos($host, "ssl://") === false) ? "ssl://".$host : $host;
        }

        ob_start();

        $smtp = new SMTP;
        // Включить вывод отладки на уровне подключения
        $smtp->do_debug = SMTP::DEBUG_CONNECTION;
        // Подключение к SMTP-серверу
        if (!$smtp->connect($host, $port)) {
            $result['message'] = 'Connect failed';
        }
        // Say hello
        if (!$smtp->hello(gethostname())) {
            $result['message'] = 'EHLO failed: ' . $smtp->getError()['error'];
        }
        // Получаем список служб ESMTP, предлагаемых сервером
        $e = $smtp->getServerExtList();
        // Если сервер может выполнять шифрование TLS, используйте его
        if (is_array($e) && array_key_exists('STARTTLS', $e)) {
            $tlsok = $smtp->startTLS();
            if (!$tlsok) {
                $result['message'] = 'Failed to start encryption: ' . $smtp->getError()['error'];
            }
            // Повторите EHLO после STARTTLS
            if (!$smtp->hello(gethostname())) {
                $result['message'] = 'EHLO (2) failed: ' . $smtp->getError()['error'];
            }
            // Получите список новых возможностей, который обычно теперь будет включать авторизацию, если раньше этого не было
            $e = $smtp->getServerExtList();
        }
        // Если сервер поддерживает аутентификацию, сделайте это (даже если нет шифрования)
        if (is_array($e) && array_key_exists('AUTH', $e)) {
            if ($smtp->authenticate($username, $password)) {
                $result['message'] = 'Connected ok!';
                $result['status']  = true;
            } else {
                $result['message'] = 'Authentication failed: ' . $smtp->getError()['error'];
            }
        }

        // Что бы ни случилось, разрываем связь.
        $smtp->quit(true);

        $result['trace'] = nl2br(ob_get_contents());
        ob_end_clean();

        return $result;

    }


}