<?php


namespace Mnv\Models\Telegram;


use Mnv\Core\DB;

class TelegramConfig
{
    /**
     * The instance itself
     * @var TelegramConfig
     */
    private static $instance;

    /** @var $_config */
    private $_config;

    /** @return TelegramConfig */
    public static function init(): TelegramConfig
    {
        if (!self::$instance) {
            self::$instance = new TelegramConfig();
        }
        return self::$instance;
    }

    /** Config constructor. */
    public function __construct()
    {
        $this->_config = DB::init()->connect()->table('telegram_settings')->select('codename, value')->indexKey('codename')->valueKey('value')->getAllIndexes();
    }

    /**
     * Получение настроек
     * @return array|mixed|null
     */
    public function config()
    {
        return $this->_config;
    }

    /**
     * @param string $codename
     * @param string $value
     */
    public function set(string $codename, string $value)
    {
        $this->_config[$codename] = $value;
    }

    /**
     * @param string $codename
     * @return mixed
     */
    public function get(string $codename)
    {
        if (array_key_exists($codename, $this->_config)) {
            return $this->_config[$codename];
        }

        $trace = debug_backtrace();
        trigger_error('Неопределённое свойство в get(): ' . $codename . ' в файле ' . $trace[0]['file'] . ' на строке ' . $trace[0]['line'], E_USER_NOTICE);
        return null;
    }

    /**
     * @param string $codename
     * @return mixed
     */
    public static function getValue(string $codename)
    {
        return self::init()->get($codename);
    }


    public function __clone()
    {
        throw new \LogicException('The Config helper cannot be cloned');
    }

    public function __wakeup()
    {
        throw new \LogicException('The Config helper cannot be serialised');
    }
}