<?php


namespace Mnv\Models\Telegram;


use Mnv\Core\DB;
use Mnv\Core\Mnv;

class TelegramReviews extends Mnv
{
    private static $_table_user = 'telegram_user';
    private static $_table = 'telegram_user_review';
    private static $_table_chat = 'telegram_user_chat';

    /** @var $reviews */
    public $reviews;

    /** @var $review */
    public $review;

    /** @var $review_id */
    public $review_id;

    /** @var $total */
    public $total;


    public function __construct()
    {
        parent::__construct();
    }


    public function getAll(): void
    {
        $this->reviews = DB::init()->connect()->table(self::$_table)->usingJoin(self::$_table_chat, 'user_id', 'LEFT ')->join(self::$_table_user, 'user_id', '=', 'id')->orderBy('review_id DESC')->indexKey('review_id')->getAllIndexes();
    }


    public function total(): void
    {
        $this->total = DB::init()->connect()->table(self::$_table)->count('*', 'count')->getValue();
    }

    public function get(): void
    {
        $this->review = DB::init()->connect()->table(self::$_table)->usingJoin(self::$_table_chat, 'user_id', 'LEFT ')->join(self::$_table_user, 'user_id', '=', 'id')->where('review_id', $this->review_id)->get();

    }

    public function remove(): bool
    {
        if (DB::init()->connect()->table(self::$_table)->where('review_id', $this->review_id)->delete()) return true;

        return false;
    }

}