<?php


namespace Mnv\Models\Telegram;

use Mnv\Core\DB;
use Mnv\Core\Mnv;

class TelegramUsers extends Mnv
{
    private static $_table = 'telegram_user';
    private static $_table_chat = 'telegram_user_chat';

    /** @var $users */
    public $users;

    /** @var $user */
    public $user;

    /** @var $userId */
    public $userId;

    /** @var $total */
    public $total;


    public function __construct()
    {
        parent::__construct();
    }


    public function getAll(): void
    {
        $this->users = DB::init()->connect()->table(self::$_table)->join(self::$_table_chat, 'user_id', '=', 'id')->orderBy('updatedAt DESC')->indexKey('id')->getAllIndexes();
    }


    public function total(): void
    {
        $this->total = DB::init()->connect()->table(self::$_table)->count('*', 'count')->getValue();
    }

    public function get(): void
    {
        $this->user = DB::init()->connect()->table(self::$_table)->join(self::$_table_chat, 'user_id', '=', 'id')->where('id', $this->userId)->get();

    }

    public function remove(): bool
    {
        if (DB::init()->connect()->table(self::$_table)->where('id', $this->userId)->delete()){
            DB::init()->connect()->table(self::$_table_chat)->where('user_id', $this->userId)->delete();
            return true;
        }

        return false;
    }

}