<?php

namespace Mnv\Models\Users;

use Mnv\Core\DB;
use Mnv\Core\Mnv;
use SmartyException;
use Mnv\Core\Managers\Role;
use Mnv\Core\Files\Image\ImageSizes;

abstract class AbstractUser extends Mnv
{
    private static $_table = 'users';
    private static $_files = 'files';
    private static $_comments = 'comments';

    /**
     * все пользователи
     * @var $users
     */
    public $users;

    /**
     * кол-во пользователей
     * @var $total
     */
    public $total;

    /**
     * кол-во пользователей при фильтрации
     * @var $total
     */
    public $totalFiltered;

    /**
     * пользователь
     * @var $user
     */
    public $user;

    /**
     * @var $oldUser
     */
    public $oldUser;

    /**
     * @var $userId
     */
    public $userId;

    /**
     * User constructor.
     * @throws SmartyException
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Фильтровать пользователей
     *
     * 1 Для РАЗРАБОТЧИКА получить всех кроме пользователей сайта
     * 2 Для АДМИНИСТРАТОРА  получить всех кроме пользователей сайта и (РАЗРАБОТЧИКА, МЕНЕДЖЕРА,КОНСУЛЬТАНТА, СОТРУДНИКА, ОБСЛУЖИВАНИЕ)
     * 3 Только пользователей сайта
     *
     * @param string $role
     */
    private function accessLevel(string $role, $manager)
    {
        if ($role == 'adminUser') {
            /** исключить пользователей сайта */
            DB::init()->connect()->where('accessLevel', '<>', Role::CONSUMER);
            DB::init()->connect()->where('accessLevel', '<>', Role::SUBSCRIBER);
            /** если авторизовался как (АДМИНИСТРАТОР, РЕЦЕНЗЕНТ, ИЗДАТЕЛЬ, МОДЕРАТОР, РЕДАКТОР) */
            if (in_array($manager->accessLevel, [Role::ADMIN, Role::MODERATOR, Role::EDITOR, Role::WRITER])) {
                /** исключить (РАЗРАБОТЧИКОВ, МЕНЕДЖЕРОВ) */
                DB::init()->connect()->notIn('accessLevel', [Role::DEVELOPER, Role::MANAGER]);
            }
        } else {
            /** только пользователи сайта */
            DB::init()->connect()->where('accessLevel', Role::CONSUMER);
        }
    }

    /**
     * Получение всех пользователей
     *
     * @param string|null $query
     * @param string|null $status
     * @param string $role
     * @param int $page
     * @param int $limit
     * @param string $orderBy
     */
    protected function getUsers(?string $query, ?string $status, int $page, int $limit, string $role, string $orderBy, $manager): void
    {

        /** Фильтровать пользователей */
        $this->accessLevel($role, $manager);

        if (!empty($query)) {
            /** не ищет если какое нибудь поле имеет `null`, если все поля(email, loginName, fullName, firstName, lastName, phone) заполнены выдает верный результат */
            DB::init()->connect()->like('CONCAT_WS(email, loginName, fullName, firstName, lastName, phone)', "%$query%");
            /** не по всем полям(email, loginName, fullName, firstName, lastName, phone) ищет */
//            DB::init()->connect()->like('CONCAT(loginName, " ", fullName, " ", firstName, " ", lastName, " ", email, " ", phone)', "%$query%");
//            DB::init()->connect()->like('CONCAT(email,"|",loginName,"|",fullName,"|",firstName,"|",lastName,"|",phone )', "%$query%");
                /** перебивает значение `accessLevel` и выдает чуть-чуть не верный результат */
//            DB::init()->connect()->like('email', "%$query%")->orLike('loginName', "%$query%")->orLike('fullName', "%$query%")->orLike('firstName', "%$query%")->orLike('lastName', "%$query%")->orLike('address', "%$query%")->orLike('phone', "%$query%");
        }
        if (!empty($status)) DB::init()->connect()->where('status', $status);

        $this->users = DB::init()->connect()->table(self::$_table)->select('*')->limit($page, $limit)->orderBy($orderBy)->getAll();

//        print_r(DB::init()->connect()->getQuery());
    }

    /**
     * Получение кол-во пользователей
     *
     * @param string|null $query
     * @param string|null $status
     * @param string $role
     */
    protected function getCountUsers(?string $query, ?string $status, string $role, $manager): void
    {
        /** Фильтровать пользователей */
        $this->accessLevel($role, $manager);

        if (!empty($query)) {
            DB::init()->connect()->like('email', "%$query%")->orLike('loginName', "%$query%")->orLike('firstName', "%$query%")->orLike('lastName', "%$query%")->orLike('address', "%$query%")->orLike('phone', "%$query%");
        }
        if (!empty($status)) DB::init()->connect()->where('status', '=', $status);

        $this->total = DB::init()->connect()->table(self::$_table)->count('*', 'count')->getValue();
    }

    /**
     * @param string|null $query
     * @param string $role
     */
    public function countTableFilteredUsers(?string $query, string $role, $manager): void
    {
        /** Фильтровать пользователей */
        $this->accessLevel($role, $manager);

        if (!empty($query)) {
            DB::init()->connect()->like('email', "%$query%")->orLike('loginName', "%$query%")->orLike('fullName', "%$query%")->orLike('firstName', "%$query%")->orLike('lastName', "%$query%")->orLike('phone', "%$query%");
        }

        $this->totalFiltered = DB::init()->connect()->table('users')->count('*', 'count')->getValue();
    }

    /**
     * Получить пользователя
     */
    public function getUser(): void
    {
        $this->user = DB::init()->connect()->table(self::$_table)->where('userId', $this->userId)->get();
    }

    /**
     * Проверка кол-во разработчиков
     *
     * @param $role
     * @return bool
     */
    protected function getUserByRole($role) : bool
    {
        $users = DB::init()->connect()->table(self::$_table)->where('accessLevel', $role)->limit(2)->getAll();
        if (\count($users) > 1) {
            return true;
        } else {
            return  false;
        }
    }

//    /**
//     * Проверка кол-во разработчиков
//     *
//     * @return bool
//     */
//    protected function getUserByRoleDeveloper() : bool
//    {
//        $users = DB::init()->connect()->table(self::$_table)->where('accessLevel', Role::DEVELOPER)->limit(2)->getAll();
//        if (\count($users) > 1) {
//            return true;
//        } else {
//            return  false;
//        }
//    }
//
//    /**
//     * Проверка кол-во администраторов
//     *
//     * @return bool
//     */
//    protected function getUserByRoleAdmin() : bool
//    {
//        $users = DB::init()->connect()->table(self::$_table)->where('accessLevel', Role::ADMIN)->limit(2)->getAll();
//        if (\count($users) > 1) {
//            return true;
//        } else {
//            return  false;
//        }
//    }

    /**
     * Удаление пользователя
     */
    protected function removeUser() : bool
    {
        if (DB::init()->connect()->table(self::$_table)->where('userId', $this->userId)->delete()) {
            DB::init()->connect()->table(self::$_comments)->where('visitorId', $this->userId)->delete();
            return true;
        }
        return false;
    }

    /**
     * Обновление статуса пользователя
     * @return bool
     */
    protected function approveUser() : bool
    {
        if (!empty($this->userId)) {
            if (DB::init()->connect()->table(self::$_table)->where('userId', $this->userId)->update(['status' => 1])) {
                return true;
            }
        }
        return false;
    }

    /**
     * Добавление нового пользователя
     *
     * @param $userInsert
     * @return bool
     */
    protected function insertUser($userInsert) : bool
    {
        if ($this->userId = DB::init()->connect()->table(self::$_table)->insert($userInsert)) return true;

        return false;
    }

    /**
     * Изменение данных пользователя
     *
     * @param $userUpdate
     * @return bool
     */
    protected function updateUser($userUpdate) : bool
    {
        if (!empty($this->userId)) {
            if (DB::init()->connect()->table(self::$_table)->where('userId', $this->userId)->update((array)$userUpdate)) return true;
        }

        return false;
    }


    /**
     * Проверка существует ли такой менеджер или да то возвращаем его
     *
     * @param int $userId
     */
    public function getOldDataUser(int $userId) : void
    {
        $this->oldUser = DB::init()->connect()->table(self::$_table)->where('userId', $userId)->get();
    }

    /**
     * Проверяем существует ли нововведений логин в базе данных
     * @param $loginName
     */
    /**
     * @param $loginName
     * @return mixed|string|null
     */
    public function checkExistenceLoginName($loginName): ?string
    {
        if (empty($this->userId)) {
            if ($fileName = DB::init()->connect()->table(self::$_table)->select('loginName')->where('LOWER(loginName)', $loginName)->getValue()) return $fileName;
        } else {
            if ($fileName = DB::init()->connect()->table(self::$_table)->select('loginName')->where('userId','<>', $this->userId)->where('LOWER(loginName)', $loginName)->getValue()) return $fileName;
        }

        return null;
    }
    /**
     * Проверяем существует ли нововведений логин в базе данных
     *
     * @param $manager
     * @return bool
     */
    public function existUserLoginName($manager) : bool
    {
        if (DB::init()->connect()->table(self::$_table)->where('loginName = ? AND userId <> ?', [$manager->loginName, $manager->userId])->get())  return true;

        return false;
    }

    /**
     * Проверяем существует ли другой пользователь с указанными правами доступа администратор `[Role::DEVELOPER, Role::ADMIN]`
     * если он один такой то запрет на изменение
     * всегда должен существовать один пользователь с правами `[Role::DEVELOPER, Role::ADMIN]`
     *
     * @param $manager
     * @param int $role
     * @return bool
     */
    public function accessLevelRole($manager, int $role) : bool
    {
        if (!DB::init()->connect()->table(self::$_table)->where('userId <> ? AND accessLevel = ?', [$manager->userId, $role])->get())  return true;

        return false;
    }

    /**
     * Удаление фото
     *
     * @return bool
     */
    public function removeUserImage() : bool
    {
        if (!empty($this->userId)) {
            DB::init()->connect()->table(self::$_table)->where('userId', $this->userId)->update(['fileId' => 0]);
            return true;
        }

        return false;
    }

    /**
     * Получение email пользователя
     *
     * @param $userId
     * @return false|int
     */
    public function getEmailUser($userId)
    {
        if (empty($userId)) return false;

        return DB::init()->connect()->table(self::$_table)->select('email')->where('userId', $userId)->getValue();
    }

    /**
     * Проверка на совпадение email
     * @param $email
     * @return bool
     */
    public function checkEmailUser($email) : bool
    {
        if (DB::init()->connect()->table(self::$_table)->select('userId')->where('email', '=', $email)->getValue()) return false;

        return true;
    }

    /**
     * Получение пароля
     * @param $userId
     * @return bool|int
     */
    public function getUserOldPassword($userId)
    {
        if (empty($userId)) return false;
        return DB::init()->connect()->table(self::$_table)->select('password')->where('userId', $userId)->getValue();
    }


    /**
     * @param int|null $fileId
     * @return ImageSizes|null
     */
    protected function getFile(?int $fileId): ?ImageSizes
    {
        $image = null;
        if (!empty($fileId)) {
            $file = DB::init()->connect()->table('files')->select('fileId, path, fileName, size')->where('fileId', $fileId)->get();
            if ($file) $image = ImageSizes::init()->get(null, $file);
        }

        return $image;
    }

}
