<?php

namespace Mnv\Models\Users;

use Mnv\Core\DB;
use Mnv\Models\Users\Exceptions\NoUserException;
use Mnv\Models\Users\Exceptions\EmptyUserIdException;

class SubscribersUser extends AbstractUser implements UserInterface
{
    private static $_table = 'users';


    /** UsersAdmin constructor */
    public function __construct()
    {
        parent::__construct();


//        /* statuses */
//        $this->smarty->assign('statuses', lang('users:statuses'));
//        $this->smarty->assign('subscribes', lang('users:subscribes'));
    }

    /**
     * Получение всех пользователей
     *
     * @param string|null $query (optional)
     * @param string|null $status (optional)
     * @param int $page
     * @param int $limit
     * @param null $columnSortOrder (optional)
     * @param null $columnName (optional)
     */
    public function getAll(?string $query, ?string $status, int $page, int $limit, $columnSortOrder = null, $columnName = null, $manager) : void
    {
        $columnIndex = $columnSortOrder[0]['column'];

        if ($columnSortOrder) {
            $orderBy = $columnName[$columnIndex]['data'] . " " . strtoupper($columnSortOrder[0]['dir']);
        } else {
            $orderBy = 'userId DESC';
        }
        $this->users = DB::init()->connect()->table('subscribe')->select('*')->limit($page, $limit)->orderBy($orderBy)->getAll();
        foreach ($this->users as $userId => $user) {
            $this->users[$userId]->registered = adjustTime($user->registered, false, 'd.m.Y');
        }
    }

    /**
     * получение кол-во пользователей
     *
     * @param string|null $query
     * @param string|null $status
     */
    public function total(?string $query, ?string $status, $manager) : void
    {
        if (!empty($query)) DB::init()->connect()->like('email', "%$query%")->orLike('phone', "%$query%");
        $this->total = DB::init()->connect()->table('subscribe')->count('*', 'count')->getValue();
    }

    /**
     * Получить кол-во пользователей при фильтрации
     *
     * @param string|null $query
     */
    public function countTableFiltered(?string $query, $manager) : void
    {
        if (!empty($query)) DB::init()->connect()->like('email', "%$query%")->orLike('phone', "%$query%");
        $this->totalFiltered = DB::init()->connect()->table('subscribe')->count('*', 'count')->getValue();
    }

    /**
     * Редактирование пользователя
     *
     */
    public function edit() { }

    /**
     * Проверить на существование
     * @param string $field по какому полю проверять (`email` или `phone`)
     * @param string $param приходящий параметр для сравнения
     * @return bool
     */
    public function existSubscribe(string $field, string $param): bool
    {
        if (DB::init()->connect()->table('subscribe')->count('*')->where($field, '=', $param)->getValue()) return true;

        return false;
    }
    /**
     * TODO сделано
     * Сохранение нового пользователя
     *
     * @param $user
     * @param null $manager
     * @return bool
     */
    public function add($user, $manager = null): bool
    {
        if(DB::init()->connect()->table('subscribe')->insert((array)$user)) return true;

        return false;
    }

    /**
     * TODO сделано
     * Обновление информации пользователя
     * @param array $user
     */
    public function update($user, $manager) { }

    /**
     * Удаление пользователя
     *
     * @throws NoUserException
     * @throws EmptyUserIdException
     */
    public function remove()
    {
        if ( $this->userId !== null ) {
            $this->getUser();
            if ($this->user !== null) {
                DB::init()->connect()->table('subscribe')->where('userId', '=', $this->user->userId)->delete();
            } else {
                throw new NoUserException();
            }
        } else {
            throw new EmptyUserIdException();
        }

    }

    /**
     * Обновление статуса
     */
    public function approve() { }

}