<?php

namespace Mnv\Models\Users;


/**
 * Interface UserInterface
 * @package Mnv\Models\Users
 */
interface UserInterface
{

    /**
     * Получить пользователей
     *
     * @param string|null $query (optional)
     * @param string|null $status (optional)
     * @param int $page
     * @param int $limit
     * @param null $columnSortOrder (optional)
     * @param null $columnName (optional)
     * @param $manager
     */
    public function getAll(?string $query, ?string $status, int $page, int $limit, $columnSortOrder = null, $columnName = null, $manager): void;

    /**
     * Получить кол-во пользователей
     *
     * @param string|null $query (optional)
     * @param string|null $status (optional)
     * @param $manager
     * @return mixed
     */
    public function total(?string $query, ?string $status, $manager): void;

    /**
     * Получить кол-во пользователей при фильтрации
     *
     * @param string|null $query (optional)
     * @param $manager
     */
    public function countTableFiltered(?string $query, $manager): void;

    /**
     * Удаление пользователя
     */
    public function remove();

    /**
     * Обновление статуса пользователя
     */
    public function approve();

    /**
     * Редактирование пользователя
     *
     * @return mixed
     */
    public function edit();

    /**
     * Добавление нового пользователя
     *
     * @param $user
     * @param $manager
     * @return mixed
     */
    public function add($user, $manager);

    /**
     * Обновление пользователя
     *
     * @param $user
     * @param $manager
     * @return mixed
     */
    public function update($user, $manager);



}