<?php

namespace Mnv\Models;

use Mnv\Core\DB;
use Mnv\Core\Mnv;

/**
 * Class Variants
 * @package Mnv\Models
 */
class Variants extends Mnv
{
    /**
     * OrdersAdmin constructor.
     */
    public function __construct()
    {
        parent::__construct();
    }

    public function convertVariants($variantArrays): array
    {
        $variants = array();
        foreach ($variantArrays as $n => $va) {
            foreach($va as $i => $v) {
                if (empty($variants[$i]))
                    $variants[$i] = new \stdClass;
                $variants[$i]->$n = $v;
            }
        }

        return $variants;
    }

    /**
     * Функция возвращает варианты товара
     * @param $filter
     */
    public function getVariants($filter)
    {
//        print_r($filter);
        if (!empty($filter['productId'])) {
            DB::init()->connect()->where('productId', $filter['productId']);
            return DB::init()->connect()->table('product_variants')->orderBy('orderBy')->indexKey('id')->getAllIndexes();
        } else {
            return null;
        }
    }

    public function getVariant($id = null)
    {
        if (!empty($id)) {
            return DB::init()->connect()->table('product_variants')->where('id', intval($id))->get();
        }

        return null;
    }

    public function addVariant($variant)
    {
        if (empty($variant->id)) unset($variant->id);
        if (empty($variant->price)) $variant->price = '0.00';
        if (empty($variant->oldPrice)) $variant->oldPrice = '0.00';
        $variant->orderBy = 0;
//        print_r($variant);

        return DB::init()->connect()->table('product_variants')->insert((array)$variant);
//        print_r(DB::init()->connect()->getQuery());
//        return $this->id;
    }

    /**
     * @param $id
     * @param $variant
     * @return mixed
     */
    public function updateVariant($id, $variant)
    {
//        print_r($variant);
//        if (empty($variant->sku)) $variant->sku = null;
//        if (empty($variant->price)) $variant->price = '0.00';
//        if (empty($variant->oldPrice)) $variant->oldPrice = '0.00';
        DB::init()->connect()->table('product_variants')->select('*')->where('id', $id)->update((array)$variant);
        return $id;
    }

    public function deleteVariant(int $id)
    {
        DB::init()->connect()->table('product_variants')->where('id', $id)->delete();

    }




}