<?php


namespace Mnv\Modules\Maps\Exception;

/**
 * Class InvalidArgumentException
 * @package Mnv\Modules\Maps\Exception
 */
final class InvalidArgumentException extends \Exception
{
    /**
     * @param int $argument
     * @param string $type
     * @return static
     */
    public static function create(int $argument, string $type): self
    {
        $stack    = debug_backtrace();
        $function = $stack[1]['function'];

        if (isset($stack[1]['class'])) {
            $function = sprintf('%s::%s', $stack[1]['class'], $stack[1]['function']);
        }

        return new self(
            sprintf('Argument #%d of %s() must be %s %s',
                $argument,
                $function,
                in_array(lcfirst($type)[0], ['a', 'e', 'i', 'o', 'u'], true) ? 'an' : 'a',
                $type
            )
        );
    }

    /**
     * InvalidArgumentException constructor.
     * @param string $message
     * @param int $code
     * @param \Exception|null $previous
     */
    private function __construct(string $message = '', int $code = 0, \Exception $previous = null)
    {
        parent::__construct($message, $code, $previous);
    }
}