<?php

namespace Mnv\Modules\Maps;

use Mnv\Modules\Maps\Params\Geometry;
use Mnv\Modules\Maps\Params\Options;
use Mnv\Modules\Maps\Params\Properties;

//class GeoObject implements Interfaces\GeoObject
class GeoObject
{
    public string $type = "Feature";
    /** @var int */
    public int $id;

    /** @var Geometry */
    public Geometry $geometry;

    /** @var Properties */
    public Properties $properties;

    /** @var Options */
    public Options $options;
    /** @var array  */
    public array $data;


    public function setObject($item, bool $isFilter = false): GeoObject
    {
        $this->id = $item->id;
        $this->geometry     = new Geometry($item->lat, $item->lng);
        $this->properties   = new Properties($item);
//        $this->options      = new Options();
        if ($isFilter) {
//            $this->data = new YandexItemInfo($item->id);
            $this->data['title']      = $item->title;
            $this->data['content']    = $item->content;
            $this->data['address']    = $item->address;
            $this->data['phone']      = $item->phone;
        }

        return $this;
    }

    public function getObject(): GeoObject
    {
        return $this;
    }




}