<?php

namespace Mnv\Modules\Maps\Params;

/**
 * Class YandexProperties
 * @package Mnv\Modules\Maps\Yandex
 */
class Properties
{
    /** @var string $balloonContent */
    public string $balloonContent;

    /** @var int  */
    public int $room;

    /** @var int  */
    public int $price;

    /** @var string  */
    public string $type;

    /** @var string $hintContent */
    public string $hintContent;

    private $types = ['Жилая', 'Коммерческая'];

    /**
     * YandexProperties constructor.
     * @param $item
     */
    public function __construct($item)
    {

        $this->balloonContent   = $item->title . '<br />' . $item->address . '<br />' . $item->phone;
        $this->type = $this->types[rand(0, 1)];
        $this->room = rand(1, 10);
        $this->price = rand(10000000, 1000000000);

        $this->hintContent = "$item->lat, $item->lng";
    }



}