<?php

namespace Mnv\Modules\Maps;

use Mnv\Core\DB;

class YandexDB
{

    /** @var string */
    private string $_table = 'articles';

    /** @var string */
    private string $_fields = 'articleId AS id, sectionId, title, fileName, content, address, phone, workingHours, lat, lng';

    /** @var array|false|mixed|string|null  */
    private ?array $_items;

    /** @var null $instance */
    private static $instance = null;

    /**
     * @param array $filter
     * @return YandexDB|null
     */
    public static function init(array $filter): ?YandexDB
    {
        if ( self::$instance == null )
            self::$instance = new YandexDB($filter);

        return self::$instance;
    }


    public function __construct(array $filter)
    {
        if (!empty($filter['coordinates']) && !empty($filter['distance'])) {

            $lat = $filter['coordinates'][0];
            $lng = $filter['coordinates'][1];
            DB::init()->connect()->select("(((acos(sin((".$lat."*pi()/180)) * sin((`lat`*pi()/180))+cos((".$lat."*pi()/180)) * cos((`lat`*pi()/180)) * cos(((".$lng."-`lng`)*pi()/180))))*180/pi())*60*1.1515*1.609344) as distance ")
                ->having('distance', '<', $filter['distance'])->orderBy('distance ASC');
        }

        $this->_items = DB::init()->connect()->table($this->_table)->select($this->_fields)->where('typeContent', 'categorys')
//            ->where('status', 'visible')
            ->limit(100000)->getAll();

//        print_r(DB::init()->connect()->getQuery());
    }


    public function get()
    {
        return $this->_items;
    }



    public function __clone()
    {
        throw new \LogicException('The YandexDB helper cannot be cloned');
    }

    public function __wakeup()
    {
        throw new \LogicException('The YandexDB helper cannot be serialised');
    }

}