<?php

namespace Mnv\Modules\Maps\Yandex;

/**
 * Class YandexGeometry
 * @package Mnv\Modules\Maps\Yandex
 */
class YandexGeometry
{

    /** @var string $type */
    public string $type = 'Point';

    /** @var false|float[]|string[]  */
    public $coordinates = [41.311299, 69.279770];

    /**
     * YandexGeometry constructor.
     * @param string|null $lat
     * @param string|null $lng
     */
    public function __construct(string $lat = null, string $lng = null)
    {
        if (!empty($lat) && !empty($lng)) {
            $latitude = number_format($lat, '6', '.', '');
            $longitude = number_format($lng, '6', '.', '');

            $this->coordinates = [(float)$latitude, (float)$longitude];
        }

    }

}