<?php

namespace Mnv\Modules\Maps;


class YandexMaps
{

    /** @var $formatetObjects */
    public $formatetObjects;

    private $objects;

    public function __construct($coordinates = null, $params = [])
    {
        $this->objects = new YandexObjects();
        $this->objects($coordinates, $params);
    }

    private function objects($coordinates = null, $params = []): void
    {
        $this->objects->getAllObjects($coordinates, $params);
        foreach ($this->objects->items as $item) {
            $this->formatetObjects[] = new YandexObject($item);
        }
    }

    /**
     * @return $this
     */
    public function get(): YandexMaps
    {
        return $this;
    }


    public function __clone()
    {
        throw new \LogicException('The YandexMaps helper cannot be cloned');
    }

    public function __wakeup()
    {
        throw new \LogicException('The YandexMaps helper cannot be serialised');
    }

}
