<?php

namespace Mnv\Modules\Maps;

use Mnv\Modules\Maps\Yandex\YandexGeometry;
use Mnv\Modules\Maps\Yandex\YandexOptions;
use Mnv\Modules\Maps\Yandex\YandexProperties;

/**
 * Class YandexObject
 * @package Mnv\Modules\Maps
 */
class YandexObject
{
    /** @var string */
    public string $type = 'Feature';

    /** @var int */
    public int $id;

    /** @var YandexGeometry */
    public YandexGeometry $geometry;

    /** @var YandexProperties */
    public YandexProperties $properties;

    /** @var YandexOptions */
    public YandexOptions $options;


    public function __construct($item)
    {
        $this->id = $item->id;
        $this->geometry     = new YandexGeometry($item->lat, $item->lng);
        $this->properties   = new YandexProperties($item->title, $item->address, $item->phone, $item->lat, $item->lng);
//        $this->options      = new YandexOptions();
    }


}