<?php

namespace Mnv\Modules\Maps\Params;

/**
 * Class YandexProperties
 * @package Mnv\Modules\Maps\Yandex
 */
class YandexProperties
{
    /** @var string $balloonContent */
    public string $balloonContent;

    /** @var int  */
    public int $room;

    /** @var int  */
    public int $price;

    /** @var string  */
    public string $type;

    /** @var string $hintContent */
    public string $hintContent;

    /** @var string $clusterCaption */
    public string $clusterCaption;


    /** @var string $myDescription */
    public string $myDescription;


    private $types = ['Жилая', 'Коммерческая'];

    /**
     * YandexProperties constructor.
     * @param string $title
     * @param string|null $address
     * @param string|null $phone
     * @param string|null $lat
     * @param string|null $lng
     */
    public function __construct(string $title, string $address = null, string $phone = null, string $lat = null, string $lng = null)
    {

        $this->balloonContent   = $title . '<br />' . $address . '<br />' . $phone;
        $this->type = $this->types[rand(0, 1)];
        $this->room = rand(1, 10);
        $this->price = rand(10000000, 1000000000);

        $this->hintContent = "$lat, $lng";
    }



}