<?php


namespace Mnv\Modules\Maps;

use Mnv\Core\DB;
use Mnv\Core\Files\Image\ImageSizes;

/**
 * Class YandexItemInfo
 * @package Mnv\Modules\Maps
 */
class YandexItemInfo
{
    /** @var string  */
    public string $title;

    /** @var string  */
    public string $content;

    /** @var string  */
    public string $address;

    /** @var string  */
    public string $phone;

    /** @var string  */
    public string $email;

    /**
     * example https://rieltor.lifestyle.uz/themes/assets/maintenance/img/bg-body.jpg
     * @var array|mixed|string[]
     */
    public array $images = [];

    public function __construct($id)
    {
        $this->getImages($id);
        $this->images = !empty($this->images) ? $this->images : [0 => 'https://rieltor.lifestyle.uz/themes/assets/maintenance/img/bg-body.jpg'];
    }

    /**
     * получать изображения
     */
    protected function getImages($id)
    {
        $images = DB::init()->connect()->table('article_images')->where('articleId', $id)->orderBy('orderBy', 'ASC')->getAll();
        foreach ($images as $imageId => $image) {
            if ($file = DB::init()->connect()->table('files')->select('fileId, folder, path, fileName, size')->where('fileId', $image->fileId)->get()) {
                if ($image->type === 'general') {
                    $this->images[] = ImageSizes::init()->get($image, $file);
                } elseif ($image->type === 'gallery') {
                    $this->images[$imageId]  = ImageSizes::init()->get($image, $file);
                }
            }
        }
    }


}