<?php
namespace Mnv\Modules;

use Mnv\Core\DB;
use Mnv\Core\Mnv;

require_once GLOBAL_ROOT . '/includes/admin-functions.inc.php';

/**
 * Class Newsletter
 * @package Mnv\Modules
 */
class Newsletter extends Mnv
{
    private static $email;
    private static $datetime = null;
    private static $valid = true;



    public function __construct()
    {
        parent::__construct();

  
    }

    public function register($email)
    {
        if (!empty($email)) {

            self::$email    = $email;
            self::$datetime = date('Y-m-d H:i:s');

            if (empty(self::$email)) {

                $status  = "error";
                $message = lang('newsletterClass:emailEmpty'); //"Поле email адреса не должно быть пустым.";
                self::$valid = false;

            } else if (!filter_var(self::$email, FILTER_VALIDATE_EMAIL)) {

                $status  = "error";
                $message = lang('newsletterClass:emailError'); //"Вы должны заполнить поле действительным адресом электронной почты";
                self::$valid = false;
            }


            if (self::$valid) {
                $existingSignup = DB::init()->connect()->table('subscribe')->count('*')->where('email', $email)->getValue();
                $data_exists = $existingSignup > 0;

                if (!$data_exists) {
                    $status = DB::init()->connect()->table('subscribe')->insert(['email' => self::$email, 'addedOn'=> self::$datetime]);
                    if ($status) {
                        $status  = "success";
                        $message = lang('newsletterClass:successSub'); //"Вы успешно подписаны";
                    } else {
                        $status  = "error";
                        $message = lang('newsletterClass:errorSql'); //"Произошла ошибка. Пожалуйста, попробуйте еще раз";
                    }
                } else {
                    $status  = "error";
                    $message = lang('newsletterClass:emailSub'); //"Это email уже подписан";
                }
            }

            return array('status'  => $status, 'message' => $message);

        }
    }

}