<?php

namespace Mnv\Modules\Payment\Payme\Form;

use Mnv\Modules\Payment\PaymentMethodService;
use Mnv\Modules\Payment\PaymentMethodInterface;

/**
 * Class PayMeGenerationForm
 * @package Mnv\YandexApi\Payment
 */
final class PayMeGenerationForm implements PaymentMethodInterface
{

    const CALLBACK = SITE_URL.'/callback/';
    private $MERCHANT;
    private $mode;
    private $url;

    public function __construct()
    {
        $payment = new PaymentMethodService('payme');
        $this->mode     = $payment->payment_method->settings->mode;
        $this->MERCHANT = $payment->payment_method->settings->merchant;
    }

    public function form(int $orderId, float $amount, int $userId = null, string $fullName = null, string $userPhone = null, string $userEmail = null, array $note = null, string $lang = null, bool $auto = true): ?string
	{
		if (!$orderId) return null;

		$button = '<button type="submit"></button>';
		if ($auto) {
			$auto   = '<script type="text/javascript">payMePayment.submit()</script>';
			$button = '';
		}
//		if (isset($lang) && !empty($lang) && $lang != 'ru') {
//           $CALLBACK = SITE_URL . '/' . $lang . '/callback/';
//        } else {
//            $CALLBACK  = SITE_URL.'/callback/';
//        }

//		print_r($this->mode);

//        $this->url = $this->mode === 'live' ? 'https://checkout.paycom.uz/' : 'https://test.paycom.uz';

		$fields = $this->fields($orderId, $amount, $userId, $fullName, $userPhone, $userEmail, $note, $lang);

        // https://checkout.paycom.uz/ / использовать для теста https://test.paycom.uz
		return <<<HTML
<form action="https://checkout.paycom.uz/" method="post" name="payMePayment" target="_blank">
{$fields}
{$button}
</form>
{$auto}
HTML;

	}

    public function fields(int $orderId, float $amount, int $userId = null, string $fullName = null, string $userPhone = null, string $userEmail = null, array $note = null, string $lang = null): ?string
    {

		$note       = join(', ', $note);

		$fields = array(
			'merchant'          => $this->MERCHANT,
			'amount'            => $amount.'00',
			'account[order_id]' => $orderId,
			'lang'              => $lang,
			'callback'          => SITE_URL //$CALLBACK.'?order_id='.$order_id,
		);

		$html = '';


		foreach ($fields as $field => $val) {
			$html .= '<input type="hidden" name="' . $field . '" value="' . $val . '" />' . PHP_EOL;
		}
		return $html;
	}
}

/*
<form name="payme" method="POST" action="https://checkout.paycom.uz/" id="PaymentPaycom" target="_blank">
    <input type="hidden" name="merchant"          value="5b9c8c32e641de247e63d491">
    <input type="hidden" name="account[order_id]" value="'.$order_id.'">
    <input type="hidden" name="amount"            value="'.$cartsAmount.'00">
    <input type="hidden" name="callback"          value="'.SITE_URL.'/success.htm" />
    <input type="hidden" name="lang"              value="ru">
    <input type="hidden" name="button" data-type="svg" value="colored">
    <button type="submit" class="btn-res hidden"></button>
</form>
<script src="https://cdn.paycom.uz/integration/js/checkout.min.js"></script>
*/




