<?php

namespace Mnv\Modules\Payment;

use Mnv\Modules\Payment\Upay\Form\UpayGenerationForm;
use Mnv\Modules\Payment\Payme\Form\PayMeGenerationForm;
use Mnv\Modules\Payment\Click\Form\ClickGenerationForm;
use Mnv\Modules\Payment\Paybox\Form\PayboxGenerationForm;
use Mnv\Modules\Payment\Apelsin\Form\ApelsinGenerationForm;

/**
 * Class PaymentFactory
 * @package Mnv\YandexApi\Payment
 */
class PaymentFactory
{

    /**
     * @param string $paymentMethod
     * @param int $orderId
     * @param float $amount
     * @param array|null $note
     * @param int|null $userId
     * @param string|null $fullName
     * @param string|null $userPhone
     * @param string|null $userEmail
     * @param string|null $lang
     * @param bool $auto
     * @return string|null
     */
    public static function paymentMethod(string $paymentMethod, int $orderId, float $amount, int $userId = null, string $fullName = null, string $userPhone = null, string $userEmail = null, array $note = null, string $lang = null, bool $auto = true): ?string
    {
        $payment = '';
        if ($paymentMethod == 'payme') {
            $payment = self::PayMe();
        } elseif ($paymentMethod == 'click') {
            $payment = self::Click();
        } elseif ($paymentMethod == 'apelsin') {
            $payment = self::Apelsin();
        } elseif ($paymentMethod == 'paybox') {
            $payment = self::PayBox();
        }elseif ($paymentMethod == 'upay') {
            $payment = self::UPay();
        }

        return $payment->form($orderId, $amount, $userId, $fullName, $userPhone, $userEmail, $note, $lang, $auto);
    }


    /**
     * @return PayMeGenerationForm
     */
    public static function PayMe(): PayMeGenerationForm
    {
        return new PayMeGenerationForm();
    }

    /**
     * @return ClickGenerationForm
     */
    public static function Click() : ClickGenerationForm
    {
        return new ClickGenerationForm();
    }

    /**
     * @return ApelsinGenerationForm
     */
    public static function Apelsin() : ApelsinGenerationForm
    {
        return new ApelsinGenerationForm();
    }

    /**
     * @return UpayGenerationForm
     */
    public static function UPay() : UpayGenerationForm
    {
        return new UpayGenerationForm();
    }

    /**
     * @return PayboxGenerationForm
     */
    public static function PayBox() : PayboxGenerationForm
    {
        return new PayboxGenerationForm();
    }
}