<?php

namespace Mnv\Modules\Shop;

/**
 * Class Shop
 * @package Mnv\Modules\Shop
 */
class Shop
{

    public $success;
    public $errors;

    public $cart;
    protected $product;

    public function __construct()
    {
        $this->cart     = new Basket();
        $this->product  = new Product();
    }


    /**
     * КОРЗИНА
     */

    /**
     * Проверка добавляемого товара в корзину
     * @return bool
     */
    public function check_shopping_cart()
    {
        return $this->cart->checkingProductAddedToCart();
    }

    /**
     * Добавление товара в корзину
     * @param int $variant
     * @param int $quantity
     */
    public function add_to_basket(int $variant, int $quantity)
    {

        $product = $this->product->getVariant($variant);
        $quantity = empty($quantity) ? 1 : $quantity;

        $newProduct = [
            'productId'     => $product->productId,
            'amount'        => $product->price * $quantity,
            'quantity'      => $quantity,
            'variantId'     => $product->variantId,
            'variantName'   => $product->variantName,
            'sku'           => $product->sku,
            'price'         => $product->price,
            'stock'         => $product->stock,
        ];
//        print_r($newProduct);
        return $this->cart->addCart($newProduct);
    }


    /**
     * @param int $variant
     * @return array|false|mixed|string
     */
    public function get_product_basket(int $variant)
    {
        return $this->product->getVariant($variant);
    }


    /**
     * @param int $variant
     * @param int|null $quantity
     * @return array|bool
     */
    public function update_basket(int $variant, ?int $quantity)
    {
        $this->cart->getBasket();
        return $this->cart->updateCountProductBasket($variant, $quantity);
    }

    /**
     * Удаление товара из корзины
     * @param int $variant
     * @return bool
     */
    public function remove_product_basket(int $variant): bool
    {
        return $this->cart->removeProductBasket($variant);
    }

    /**
     * Удаление всех товаров из корзины
     * @return bool
     */
    public function remove_all_products_basket(): bool
    {
        return $this->cart->removeProductAllBasket();
    }

    /**
     * Кол-во товара в корзине
     * @return int
     */
    public function products_count_basket(): int
    {

        return $this->cart->getCountProductsBasket();
    }

    /**
     * Общая сумма корзины
     * @return int
     */
    public function total_price_basket()
    {
        return $this->cart->getTotalAmountBasket();
    }

    /**
     * Формат цены
     * @param $price
     * @param bool $format
     * @return float|int|string
     */
    public function price_format($price, bool $format = true)
    {
        global $activeCurrency;

        $result = $price * $activeCurrency['course'];
        if ($format) $result = number_format($result, $activeCurrency['cent'], '.', $activeCurrency['thousands_separator']);

        if ($activeCurrency['codeName'] == '$' || $activeCurrency['codeName'] == '€') {
            $result = $activeCurrency['codeName'] . '' . $result;
        } else {
            $result = $result . ' ' . $activeCurrency['codeName'];
        }

        return $result;
    }






}