<?php

namespace Mnv\Modules\Telegram\Controllers;

use Mnv\Modules\Telegram\Commands\Commands;
use Mnv\Modules\Telegram\Telegram;
use Mnv\Modules\Telegram\Models\Categories;
use Mnv\Modules\Telegram\Helpers\GenerateInlineButtons;

/**
 * Class CategoryController
 * @package Mnv\Modules\Telegram\Controllers
 */
class CategoryController
{
    /** @var CategoryController|null $instance */
    private static ?CategoryController $instance = null;

    private int $defaultSectionId = 2;

    /** @return CategoryController|null */
    public static function init(): ?CategoryController
    {
        if ( self::$instance == null )
            self::$instance = new CategoryController();

        return self::$instance;
    }

    /**
     * @param Telegram $telegram
     * @param int $chatID
     * @return mixed
     */
    public function execute(Telegram $telegram, int $chatID)
    {
        if ($telegram->Callback_Query()) {
            $MessageID = $telegram->MessageID();
            $callbackData = $telegram->Callback_Data();

            $data = array_slice(explode('::', $callbackData), 1);
            $method = array_shift($data);
//            sendMessage($method);
            $response = $method && method_exists($this, $method) ? $this->$method($telegram, $data[0]) : $this->categories($telegram, $this->defaultSectionId);

            if (is_array($response)) {
                $response['chat_id'] = $chatID;
                $response['message_id'] = $MessageID;

                return $telegram->editMessageText($response);
            }

            return $telegram->sendMessage([
                'chat_id' => $chatID,
                'message_id' => $MessageID,
                'text' => Commands::getMessageText('mistake'),
            ]);
        }

        return $telegram->sendMessage(array_merge([
            'chat_id' => $chatID
        ], $this->categories($telegram, $this->defaultSectionId)));
    }

    /**
     * Категории
     *
     * @param Telegram $telegram
     * @param int $sectionId
     * @return array|null
     */
    private function categories(Telegram $telegram, int $sectionId = 2): ?array
    {
        if (!$rows = Categories::getSections($sectionId, '/Category',  'subCategories')) {
            return null;
        }
        $keyboards = GenerateInlineButtons::prepareKeyboard(...$rows);
        $keyboards[] = [$telegram->buildInlineKeyboardButton(Commands::getMessageText('back_btn'), null, "/back_to_main")];

        return [
            'text' => Commands::getMessageText('select_category'),
            'reply_markup' => $telegram->buildInlineKeyBoard($keyboards),

        ];
    }

    /**
     * Под категории
     *
     * @param Telegram $telegram
     * @param int $sectionId
     * @return array|null
     */
    public function subCategories(Telegram $telegram, int $sectionId = 2): ?array
    {
        if (!$rows = Categories::getSections($sectionId, '/Articles',  'objects')) {
            return null;
        }

        $keyboards = GenerateInlineButtons::prepareKeyboard(...$rows);
        $keyboards[] = [$telegram->buildInlineKeyboardButton(Commands::getMessageText('back_to_categories'), null, implode('::', ['/Category', 'categories', 2]))];

        return [
            'text' => Commands::getMessageText('choose_direction'),
            'reply_markup' => $telegram->buildInlineKeyBoard($keyboards),
        ];
    }

}