<?php

namespace Mnv\Modules\Telegram\Helpers;

/**
 * Class PointCoordinates
 * @package Mnv\Modules\Telegram\Helpers
 */
class PointCoordinates
{
    /** @var $x */
    public $x;

    /** @var $y */
    public $y;

    /**
     * PointCoordinates constructor.
     * @param $x
     * @param $y
     */
    public function __construct($x, $y)
    {
        $this->x = $x;
        $this->y = $y;
    }

    /**
     * @param PointCoordinates $point
     * @return float
     */
    public function distanceTo(PointCoordinates $point): float
    {
        $distanceX = $this->x - $point->x;
        $distanceY = $this->y - $point->y;
        return sqrt($distanceX * $distanceX + $distanceY * $distanceY);
    }

    /**
     * @param $latitude1
     * @param $longitude1
     * @param $latitude2
     * @param $longitude2
     * @return float
     */
    public function getDistanceBetweenPoints($latitude1, $longitude1, $latitude2, $longitude2): float
    {
        $theta = $longitude1 - $longitude2;
        $miles = (sin(deg2rad($latitude1)) * sin(deg2rad($latitude2))) + (cos(deg2rad($latitude1)) * cos(deg2rad($latitude2)) * cos(deg2rad($theta)));
        $miles = acos($miles);
        $miles = rad2deg($miles);
        $miles = $miles * 60 * 1.1515;
//        $feet = $miles * 5280;
//        $yards = $feet / 3;
        $kilometers = $miles * 1.609344;
//        $meters = $kilometers * 1000;
        return $kilometers;
//        return compact('miles', 'feet', 'yards', 'kilometers', 'meters');
    }
}