<?php


namespace Mnv\Modules\Telegram\Pages;

use Mnv\Modules\Telegram\Telegram;
use Mnv\Modules\Telegram\TelegramUser;

use Mnv\Modules\Telegram\Models\Categories;
use Mnv\Modules\Telegram\Models\AddingObject;

use Mnv\Modules\Telegram\Commands\Commands;
use Mnv\Modules\Telegram\Helpers\GenerateInlineButtons;

/**
 * Class ObjectPage
 * @package Mnv\Modules\Telegram\Pages
 */
class ObjectPage
{

    private static ?ObjectPage $instance = null;

    private static function getInstance(): ?ObjectPage
    {
        if (self::$instance == null) {
            self::$instance = new ObjectPage();
        }

        return self::$instance;
    }

    public static function init(): ObjectPage
    {
        return self::getInstance();
    }

    public function executePage(Telegram $telegram, TelegramUser $user, $chatID, string $method, ?int $paramId, int $setPage = 10)
    {
        /** page */
        $user->setPage($setPage);
        $MessageID = $telegram->MessageID();
        $response = ($method && method_exists($this, $method)) ? $this->$method($telegram, $chatID, $paramId) : $this->startPage($telegram, $chatID, $paramId);

        if (is_array($response)) {
            $response['chat_id']        = $chatID;
            $response['message_id']     = $MessageID;
            $response['parse_mode']     = "HTML";

            return $telegram->sendMessage($response);
        }

        return $telegram->sendMessage([
            'chat_id'       => $chatID,
            'message_id'    => $MessageID,
            'text'          => Commands::getMessageText('mistake'),
        ]);

    }

    /**
     * Страница добавление объекта / page 13
     *
     * @param Telegram $telegram
     * @param int $chatID
     * @param null $paramId
     * @return array
     */
    public function startPage(Telegram $telegram, int $chatID, $paramId = null): array
    {
        $option = [
            [$telegram->buildKeyboardButton(Commands::getMessageText('cancel_btn'))]
        ];
        $keyboard = $telegram->buildKeyBoard($option,  false,  true);
        return [
            'reply_markup'  => $keyboard,
            'text'          => Commands::getMessageText('enter_name_object'),
        ] ;
    }

    /**
     * Страница добавление объекта / page 13
     *
     * @param Telegram $telegram
     * @param int $chatID
     * @param null $paramId
     * @return array
     */
    public function categoryPage(Telegram $telegram, int $chatID, $paramId = null): array
    {
        $rows = Categories::getCategories(2);
        $option = GenerateInlineButtons::buildKeyboard($telegram, $rows, null);

        $option[] = [$telegram->buildKeyboardButton(Commands::getMessageText('cancel_btn')), $telegram->buildKeyboardButton(Commands::getMessageText('back_btn'))];
        $keyboard = $telegram->buildKeyBoard($option,  false,  true);
        return [
            'reply_markup'  => $keyboard,
            'text'          => Commands::getMessageText('select_category_object'),
        ];
    }

    /**
     * Страница добавление объекта / page 13
     *
     * @param Telegram $telegram
     * @param int $chatID
     * @param int $categoryId
     * @return array
     */
    public function subCategoryPage(Telegram $telegram, int $chatID, int $categoryId): array
    {
        $rows = Categories::getCategories($categoryId);
        $option = GenerateInlineButtons::buildKeyboard($telegram, $rows, null);

        $option[] = [$telegram->buildKeyboardButton(Commands::getMessageText('cancel_btn')), $telegram->buildKeyboardButton(Commands::getMessageText('back_btn'))];
        $keyboard = $telegram->buildKeyBoard($option,  false,  true);
        return [
            'reply_markup'  => $keyboard,
            'text'          => Commands::getMessageText('select_subcategory_object'),
        ];
    }

    /**
     * Страница добавление объекта / page 13
     *
     * @param Telegram $telegram
     * @param int $chatID
     * @param null $paramId
     * @return array
     */
    public function contentPage(Telegram $telegram, int $chatID, $paramId = null): array
    {
        $option = [
            [$telegram->buildKeyboardButton('Пропустить')],
            [$telegram->buildKeyboardButton(Commands::getMessageText('cancel_btn')), $telegram->buildKeyboardButton(Commands::getMessageText('back_btn'))],
        ];
        $keyboard = $telegram->buildKeyBoard($option,  false,  true);
        return [
            'reply_markup'  => $keyboard,
            'text'          => Commands::getMessageText('enter_description_object'),
        ];
    }

    /**
     * Страница добавление объекта / page 11
     *
     * @param Telegram $telegram
     * @param int $chatID
     * @param null $paramId
     * @return array
     */
    public function regionPage(Telegram $telegram, int $chatID, $paramId = null): array
    {

        $option = [];
        $regions = Categories::getSectionRegions();
        foreach ($regions as $region) {
            $option[] = [$telegram->buildKeyboardButton($region)];
        }

        $option[] = [$telegram->buildKeyboardButton(Commands::getMessageText('cancel_btn')), $telegram->buildKeyboardButton(Commands::getMessageText('back_btn'))];

        $keyboard = $telegram->buildKeyBoard($option,  false,  true);
        return [
            'reply_markup'  => $keyboard,
            'text'          => Commands::getMessageText('select_city_object'),
        ];
    }

    /**
     * Страница добавление объекта / page 15
     *
     * @param Telegram $telegram
     * @param int $chatID
     * @param int $regionId
     * @return array
     */
    public function areaPage(Telegram $telegram, int $chatID, int $regionId): array
    {
        $option = [];
        $districts = Categories::getSectionArea($regionId);
        foreach ($districts as $district) {
            $option[] = [$telegram->buildKeyboardButton($district)];
        }

        $option[] = [$telegram->buildKeyboardButton(Commands::getMessageText('cancel_btn')), $telegram->buildKeyboardButton(Commands::getMessageText('back_btn'))];

        $keyboard = $telegram->buildKeyBoard($option,  false,  true);

        return [
            'reply_markup'  => $keyboard,
            'text'          => Commands::getMessageText('select_district'),
        ];
    }

    /**
     * Страница добавление объекта / page 13
     *
     * @param Telegram $telegram
     * @param int $chatID
     * @param null $paramId
     * @return array
     */
    public function streetPage(Telegram $telegram, int $chatID, $paramId = null): array
    {
        $option = [
            [$telegram->buildKeyboardButton(Commands::getMessageText('cancel_btn')), $telegram->buildKeyboardButton(Commands::getMessageText('back_btn'))]
        ];
        $keyboard = $telegram->buildKeyBoard($option,  false,  true);
        return [
            'reply_markup'  => $keyboard,
            'text'          => Commands::getMessageText('enter_address_object'),
        ];
    }
    /**
     * Страница добавление режима работы / page 14
     *
     * @param Telegram $telegram
     * @param int $chatID
     * @param null $paramId
     * @return array
     */
    public function coordinatesPage(Telegram $telegram, int $chatID, $paramId = null): array
    {
        $option = [
            [$telegram->buildKeyboardButton(Commands::getMessageText('send_coordinates'), false, true)],
            [$telegram->buildKeyboardButton(Commands::getMessageText('cancel_btn')), $telegram->buildKeyboardButton(Commands::getMessageText('back_btn'))]
        ];
        $keyboard = $telegram->buildKeyBoard($option,  false,  true);
        return [
            'reply_markup'  => $keyboard,
            'text'          => Commands::getMessageText('send_coordinates_object'),
        ];
    }

    /**
     * Страница добавление номера телефона / page 14
     *
     * @param Telegram $telegram
     * @param int $chatID
     * @param null $paramId
     * @return array
     */
    public function phonePage(Telegram $telegram, int $chatID, $paramId = null): array
    {
        $option = [
            [$telegram->buildKeyboardButton(Commands::getMessageText('send_contact'), true, false)],
            [$telegram->buildKeyboardButton(Commands::getMessageText('cancel_btn')), $telegram->buildKeyboardButton(Commands::getMessageText('back_btn'))]
        ];
        $keyboard = $telegram->buildKeyBoard($option,  false,  true);
        return [
            'reply_markup'  => $keyboard,
            'text'          => Commands::getMessageText('add_phone'),
        ];
    }

    /**
     * Страница добавление режима работы / page 14
     *
     * @param Telegram $telegram
     * @param int $chatID
     * @param null $paramId
     * @return array
     */
    public function openingHoursStartPage(Telegram $telegram, int $chatID, $paramId = null): array
    {
        $option = [];
        $option[] = [$telegram->buildKeyboardButton("24/7")];
        for ($h = 0; $h < 24; $h++) {
            $time = sprintf('%02d:%02d', $h, '00');
            $option[]   = [$telegram->buildKeyboardButton($time)];
        }

//        $option[] = [$telegram->buildKeyboardButton(Commands::getMessageText('cancel_btn'))];
        $option[] = [$telegram->buildKeyboardButton(Commands::getMessageText('cancel_btn')), $telegram->buildKeyboardButton(Commands::getMessageText('back_btn'))];
        $keyboard = $telegram->buildKeyBoard($option,  false,  true);
        return [
            'reply_markup'  => $keyboard,
            'text'          => Commands::getMessageText('select_start_hours_object'),
        ];
    }
    /**
     * Страница добавление режима работы / page 14
     *
     * @param Telegram $telegram
     * @param int $chatID
     * @param null $paramId
     * @return array
     */
    public function openingHoursEndPage(Telegram $telegram, int $chatID, $paramId = null): array
    {
        $option = [];
        for ($h = 0; $h < 24; $h++) {
            $time = sprintf('%02d:%02d', $h, '00');
            $option[]   = [$telegram->buildKeyboardButton($time)];
        }

//        $option[] = [$telegram->buildKeyboardButton(Commands::getMessageText('cancel_btn'))];
        $option[] = [$telegram->buildKeyboardButton(Commands::getMessageText('cancel_btn')), $telegram->buildKeyboardButton(Commands::getMessageText('back_btn'))];
        $keyboard = $telegram->buildKeyBoard($option,  false,  true);
        return [
            'reply_markup'  => $keyboard,
            'text'          => Commands::getMessageText('select_end_hours_object'),
        ];
    }

    /**
     * Страница добавление режима работы / page 14
     *
     * @param Telegram $telegram
     * @param int $chatID
     * @param null $paramId
     * @return array
     */
    public function workingDaysWeekPage(Telegram $telegram, int $chatID, $paramId = null): array
    {
        $object = new AddingObject($chatID);

        $weekdays = Categories::getWeekdayList();

        $workingDays = $object->getParamValueObject($chatID, $object->object_id, 'workingDays');
        $workingDays = json_decode($workingDays, true);

        $option = [];
        foreach ($weekdays as $key => $workingDay) {
            $dayId = null;
            if (!empty($workingDays)) {
                $dayId = (array_search($workingDay, $workingDays) !== false) ? array_search($workingDay, $workingDays) : null;
            }
            $extra = ($dayId === $key) ? '✔ ' : '';
            $option[]   = [$telegram->buildKeyboardButton($extra . $workingDay)];
        }

        $option[] = [$telegram->buildKeyboardButton(Commands::getMessageText('confirm_btn'))];
        $option[] = [$telegram->buildKeyboardButton(Commands::getMessageText('cancel_btn')), $telegram->buildKeyboardButton(Commands::getMessageText('back_btn'))];
        $keyboard = $telegram->buildKeyBoard($option,  false,  true);
        return [
            'reply_markup'  => $keyboard,
            'text'          => Commands::getMessageText('select_working_days_object'),
        ];
    }



    /**
     * Страница добавление фото к объекту / page 20
     *
     * @param Telegram $telegram
     * @param int $chatID
     * @param null $paramId
     * @return array
     */
    public function addPhotoPage(Telegram $telegram, int $chatID, $paramId = null): array
    {
        $option = [
            [$telegram->buildKeyboardButton(Commands::getMessageText('cancel_btn')),$telegram->buildKeyboardButton(Commands::getMessageText('back_btn'))]
        ];
        $keyboard = $telegram->buildKeyBoard($option,  false,  true);
        return [
            'reply_markup'  => $keyboard,
            'text'          => Commands::getMessageText('add_photo_object'),
        ];
    }

    /**
     * Проверить объект / page 18
     *
     * @param Telegram $telegram
     * @param int $chatID
     * @param null $paramId
     * @return array
     */
    public function confirmObject(Telegram $telegram, int $chatID, $paramId = null): array
    {
        $object = new AddingObject($chatID);
        $result = $object->getObject($chatID, $object->object_id);

        $option = [
            [$telegram->buildKeyboardButton(Commands::getMessageText('view_location_object'))],
            [$telegram->buildKeyboardButton(Commands::getMessageText('preview_object'))],
            [$telegram->buildKeyboardButton(Commands::getMessageText('confirm_save_btn'))],
            [$telegram->buildKeyboardButton(Commands::getMessageText('cancel_btn')), $telegram->buildKeyboardButton(Commands::getMessageText('back_btn'))],

        ];
        $keyboard = $telegram->buildKeyBoard($option,  false,  true);
        return [
            'reply_markup'  => $keyboard,
            'text'          => $result,
        ];
    }

//    /**
//     *
//     * @param Telegram $telegram
//     * @param int $chatID
//     * @param null $paramId
//     * @return array
//     */
//    public function successObject(Telegram $telegram, int $chatID, $paramId = null): array
//    {
//        $option = [
//            [$telegram->buildKeyboardButton(Commands::getMessageText('search'))],
//            [$telegram->buildKeyboardButton(Commands::getMessageText('rules')), $telegram->buildKeyboardButton(Commands::getMessageText('add_object'))],
//            [$telegram->buildKeyboardButton(Commands::getMessageText('support')), $telegram->buildKeyboardButton(Commands::getMessageText('leave_review'))],
//            [$telegram->buildKeyboardButton(Commands::getMessageText('setting_btn'))],
//        ];
//
//        $keyboard = $telegram->buildKeyBoard($option,  false,  true);
//        return [
//            'reply_markup'  => $keyboard,
//            'text'          => '✅ Объект успешно добавлен, после модерации появится в поисковой системе бота',
//        ];
//    }



//    /**
//     * Страница добавление объекта / page 13
//     *
//     * @param Telegram $telegram
//     * @param $chatID
//     */
//    public function actionPage(Telegram $telegram, $chatID)
//    {
//        $option = [
//            [$telegram->buildKeyboardButton('Отмена')],
//        ];
//        $keyboard = $telegram->buildKeyBoard($option,  false,  true);
//        $telegram->sendMessage([
//            'chat_id'       => $chatID,
//            'reply_markup'  => $keyboard,
//        ]);
//    }

}