<?php

namespace Mnv\Modules\Telegram\Pages;

use Mnv\Modules\Telegram\Models\Categories;
use Mnv\Modules\Telegram\Telegram;
use Mnv\Modules\Telegram\TelegramUser;
use Mnv\Modules\Telegram\Commands\Commands;

/**
 * Class Start
 * @package Mnv\Modules\Telegram\Pages
 */
class Start
{
    /**
     * Page welcome 0
     *
     * @param Telegram $telegram
     * @param TelegramUser $user
     * @param $chatID
     */
    public static function welcome(Telegram $telegram, TelegramUser $user, $chatID)
    {
        /** page */
        $user->setPage(0);
        $text = Categories::getSectionContent(148);
        $option = [
            [$telegram->buildKeyboardButton(Commands::getMessageText('ru')), $telegram->buildKeyboardButton(Commands::getMessageText('uz'))],
        ];
        $keyboard = $telegram->buildKeyBoard($option,  false,  true);
        $content = array_merge(['chat_id' => $chatID, 'reply_markup' => $keyboard, 'parse_mode' => "HTML"], $text);
        $telegram->sendMessage($content);
    }

    /**
     *
     * @param Telegram $telegram
     * @param TelegramUser $user
     * @param $chatID
     */
    public static function showSetContract(Telegram $telegram, TelegramUser $user, $chatID)
    {
        /** page */
        $user->setPage(1);

        $option = [
            [$telegram->buildKeyboardButton(Commands::getMessageText('send_contact'), true, false)],
        ];
        $keyboard = $telegram->buildKeyBoard($option,  false,  true);

        $telegram->sendMessage([
            'chat_id'       => $chatID,
            'reply_markup'  => $keyboard,
            'text'          => Commands::getMessageText('add_phone'),
            'parse_mode'    => "HTML"
        ]);
    }

    /**
     * Page general 2
     * @param TelegramUser $user
     * @param Telegram $telegram
     * @param int $chatID
     * @param int $setPage
     * @param string|null $text
     */
    public static function general(Telegram $telegram, TelegramUser $user, int $chatID, int $setPage = 2, string $text = null)
    {
        /** page */
        $user->setPage($setPage);

        $option = [
            [$telegram->buildKeyboardButton(Commands::getMessageText('search'))],
            [$telegram->buildKeyboardButton(Commands::getMessageText('rules')), $telegram->buildKeyboardButton(Commands::getMessageText('add_object'))],
            [$telegram->buildKeyboardButton(Commands::getMessageText('support')), $telegram->buildKeyboardButton(Commands::getMessageText('leave_review'))],
            [$telegram->buildKeyboardButton(Commands::getMessageText('setting_btn'))],
        ];
        if (is_null($text) || empty($text)) {
            $text = Commands::getMessageText('interests');
        }
        $keyboard = $telegram->buildKeyBoard($option,  false,  true);
        $telegram->sendMessage([
            'chat_id'       => $chatID,
            'reply_markup'  => $keyboard,
            'text'          => $text,
            'parse_mode'    => "HTML"
        ]);
    }

    /**
     * Page main 3
     * @param TelegramUser $user
     * @param Telegram $telegram
     * @param int $chatID
     * @param int $MessageID
     * @param int $setPage
     * @param string $text
     */
    public static function main(Telegram $telegram, TelegramUser $user, int $chatID, int $MessageID, int $setPage = 3, $text = null)
    {
        /** page */
        $user->setPage($setPage);

        if (is_null($text) || empty($text)) {
            $text = Commands::getMessageText('location_text');
        } else {
            $telegram->deleteMessage(['chat_id' => $chatID, 'message_id' => $MessageID]);
        }
        $option = [
            [$telegram->buildKeyboardButton(Commands::getMessageText('search_location'), false, true)],
            [$telegram->buildKeyboardButton(Commands::getMessageText('search_category'), false, false), $telegram->buildKeyboardButton(Commands::getMessageText('search_district'), false, false)],
//            [$telegram->buildKeyboardButton(Commands::getMessageText('search_category'), false, false), $telegram->buildKeyboardButton(Commands::getMessageText('search_name'), false, false)],
            [$telegram->buildKeyboardButton(Commands::getMessageText('back_btn'), false, false)],
        ];

        $keyboard = $telegram->buildKeyBoard($option, false, true);
        $telegram->sendMessage([
            'chat_id'       => $chatID,
            'reply_markup'  => $keyboard,
            'text'          => $text,
            'parse_mode'    => "HTML"
        ]);
    }

//    /**
//     * Page main 3
//     * @param TelegramUser $user
//     * @param Telegram $telegram
//     * @param int $chatID
//     * @param int $MessageID
//     */
//    public static function mainRestart(Telegram $telegram, TelegramUser $user, int $chatID, int $MessageID)
//    {
//        /** page */
//        $user->setPage(3);
//        $option = [
//            [$telegram->buildKeyboardButton(Commands::getMessageText('search_location'), false, true), $telegram->buildKeyboardButton(Commands::getMessageText('search_district'))],
//            [$telegram->buildKeyboardButton(Commands::getMessageText('search_category')), $telegram->buildKeyboardButton(Commands::getMessageText('search_name'))],
//            [$telegram->buildKeyboardButton(Commands::getMessageText('back_btn'))],
//        ];
//
//        $keyboard = $telegram->buildKeyBoard($option, false, true);
//        $telegram->deleteMessage(['chat_id' => $chatID, 'message_id' => $MessageID]);
//        $telegram->sendMessage([
//            'chat_id'       => $chatID,
//            'reply_markup'  => $keyboard,
//            'text'          => '🏠',
//            'parse_mode'    => "HTML"
//        ]);
//    }

    /**
     * Page catalog 4
     * @param TelegramUser $user
     * @param Telegram $telegram
     * @param int $chatID
     */
    public static function searchYandex(Telegram $telegram, TelegramUser $user, int $chatID)
    {
        /** page */
        $user->setPage(4);

        $option = [
            [$telegram->buildKeyboardButton(Commands::getMessageText('back_btn'))],
        ];

        $keyboard = $telegram->buildKeyBoard($option, false, true);
        $telegram->sendMessage([
            'chat_id'       => $chatID,
            'reply_markup'  => $keyboard,
            'text'          => 'Поиск с помощью яндекс'
        ]);
    }

}