<?php


namespace Mnv\Modules\Telegram;

/**
 * Class I18N
 * @package Mnv\Modules\Telegram
 */
final class TelegramI18N
{
    // TODO: добавить язык по умолчанию
    // TODO: добавить функцию для изменения языковой папки / пути

    private $loadedLangs = [];
    private $activeLang;
    private $langPath = __DIR__ . "/i18n/";

    /**
     * загружает языковой массив из файла json
     * @param string $lang
     */
    private function loadLangFromFile(string $lang)
    {
        // TODO: добавить файл, проверить загрузку | выдать ошибки, если такого файла нет
        //загрузка и декодирование .json lang в массив
        $langArray = json_decode(file_get_contents($this->langPath . $lang . ".json"), true);

        // добавить загруженный язык в массив, добавляем в память
        $this->loadedLangs[$lang] = $langArray;
    }

    /**
     * загружает язык из файла, если язык уже загружен - активирует его
     * @param string $lang язык для загрузки/активации
     */
    public function loadLang(string $lang)
    {
        // проверяем, загрузили ли мы уже в массив / память
        if (!isset($this->loadedLangs[$lang])) {
            // загружаем этот язык в память
            $this->loadLangFromFile($lang);
        }

        $this->activeLang = $lang;
    }

    /**
     * Возврат фразы  на активном языке
     *
     * @param string $phrase текущая фраза для возврата
     * @return string
     */
    public function get(string $phrase): string
    {
        // TODO: проверка наличия фразы
        return $this->loadedLangs[$this->activeLang][$phrase];
    }

    /**
     * Возврат фразы на активном языке для группы/фразы
     *
     * @param string $group группа фраз, проверьте i18n /en.json для получения дополнительной информации или документов
     * @param string $phrase текущая фраза для возврата
     * @return string
     */
    public function getGroup(string $group, string $phrase): string
    {
        // TODO: проверка наличия группы / фразы
        return $this->loadedLangs[$this->activeLang][$group][$phrase];
    }
}