<?php
namespace Mnv\Modules\Telegram\Yandex;

/**
 * Class GeoObject
 * @package Mnv\Modules\Telegram\Yandex
 */
class GeoObject
{

    /** @var array $_data */
    public array $_data;

    /** @var array $_rawData */
    protected array $_rawData;

    /**
     * GeoObject constructor.
     * @param array $rawData
     */
    public function __construct(array $rawData)
    {
        $data = array(
            'id'            => $rawData['properties']['CompanyMetaData']['id'],
            'title'         => $rawData['properties']['CompanyMetaData']['name'],
            'address'       => $rawData['properties']['CompanyMetaData']['address'] ?? null,
            'workingHours'  => $rawData['properties']['CompanyMetaData']['Hours']['text'] ?? null,
            'site'          => $rawData['properties']['CompanyMetaData']['url'] ?? null,
            'description'   => $rawData['properties']['description'] ?? null,

        );
        if (isset($rawData['properties']['CompanyMetaData']['Phones'])) {
            $phones = [];
            foreach ($rawData['properties']['CompanyMetaData']['Phones'] as $phone) {
//                $data['phone'][] = $phone['formatted'];
                $phones[] = $phone['formatted'];
            }
            $data['phone'] = implode(", ", $phones);
        }
        if (isset($rawData['properties']['CompanyMetaData']['Categories'])) {
            foreach ($rawData['properties']['CompanyMetaData']['Categories'] as $category) {
                $data['categories'][] = $category['name'];
            }
        }
        if (isset($rawData['geometry']['coordinates'])) {
//            $data['coordinates'] = $rawData['geometry']['coordinates'];
            $data['longitude'] = number_format((float)$rawData['geometry']['coordinates'][0], 10, '.', '');
            $data['latitude'] = number_format((float)$rawData['geometry']['coordinates'][1], 10, '.', '');
        }
        $this->_data = $data;
//        $this->_rawData = $rawData;
    }

    public function __sleep()
    {
        return array('_data');
    }

    /**
     * Необработанные данные
     * @return array
     */
    public function getRawData(): array
    {
        return $this->_rawData;
    }

    /**
     * Обработанные данные
     * @return array
     */
    public function getData(): array
    {
        return $this->_data;
    }

    /**
     * Широта в градусах. Имеет десятичное представление с точностью до семи знаков после запятой
     * @return float|null
     */
    public function getLatitude(): ?float
    {
        return $this->_data['latitude'] ?? null;
    }

    /**
     * Долгота в градусах. Имеет десятичное представление с точностью до семи знаков после запятой
     * @return float|null
     */
    public function getLongitude(): ?float
    {
        return $this->_data['longitude'] ?? null;
    }

    /**
     * Полный адрес
     * @return string|null
     */
    public function getAddress(): ?string
    {
        return $this->_data['address'] ?? null;
    }

    /**
     * Тип
     * @return string|null
     */
    public function getTitle(): ?string
    {
        return $this->_data['title'] ?? null;
    }
}
