<?php


use Mnv\Core\Config;
use Mnv\Core\DB;
use Mnv\Core\Design;
use Mnv\Core\Locale\i18n;

/**
 * проверяем, что функция mb_ucfirst не объявлена и включено расширение mbstring (Multibyte String Functions)
 */
if (!function_exists('mb_ucfirst') && extension_loaded('mbstring'))
    {
        /**
         * mb_ucfirst - преобразует первый символ в верхний регистр
         * @param string $str - строка
         * @param string $encoding - кодировка, по-умолчанию UTF-8
         * @return string
         */
        function mb_ucfirst($str, $encoding = 'UTF-8')
        {
            $str = mb_ereg_replace('^[\ ]+', '', $str);
            $str = mb_strtoupper(mb_substr($str, 0, 1, $encoding), $encoding). mb_substr($str, 1, mb_strlen($str), $encoding);
            return $str;
        }
    }

    /**
     * Checks if language is RTL
     * @param string $lang_code language code
     * @return boolean true if RTL
     */
    function is_language($lang_code = 'ru')
    {
        $languages = array(
            'ru',
            'en',
            'uz',
        );

        return in_array($lang_code, $languages);
    }

    function saveSerializations(?array $buildLang = array()): bool
    {
        global $smarty, $SECTIONS, $TREE, $CURRENCIES;

        buildSectionArrays($buildLang);
        buildCurrencyArrays();

        $tmpSmarty = Design::init()->design();

        //        $serializations['TREE']       = improved_var_export($TREE, true);
        $serializations['SECTIONS']   = improved_var_export($SECTIONS, true);
        $serializations['CURRENCIES'] = improved_var_export($CURRENCIES, true);

//        $smarty->assign('TREE', $TREE);
        $smarty->assign('SECTIONS', $SECTIONS);
        $smarty->assign('CURRENCIES', $CURRENCIES);

        $tmpSmarty->assign('serializations', $serializations);
        $tmpSmarty->defaultModifiers(array());

        $siteRoot =  empty($buildLang) ? SITE_ROOT : ($buildLang->isDefault ? GLOBAL_ROOT : GLOBAL_ROOT . '/' . $buildLang->codename);

        $fh = fopen($siteRoot . '/includes/serializations.inc.php', 'w');
        if ($fh) {
            fwrite($fh, $tmpSmarty->fetch(GLOBAL_ROOT . '/admin/templates/serializations.tpl', '', 'admin'));
            fclose($fh);
            return true;
        }
        return false;
    }

    function buildSectionArrays($buildLang = array()) {
        global $SECTIONS, $TREE, $databaseConfig;

        /* section path */
        $SECTION_PATH = empty($buildLang) ? SITE_URL : ($buildLang['isDefault'] ? GLOBAL_URL : GLOBAL_URL.'/'.$buildLang['codename']);

        /* retrieve all sections */
        $SECTIONS = DB::init()->connect()->table('sections')->orderBy('parentId, sortOrder')->indexKey('sectionId')->getAllIndexes();

        /* find all parent sections */
        foreach($SECTIONS as $sectionId=>$section){
            $SECTIONS[$sectionId]->parents = array_reverse(getAllParents($sectionId));
            $SECTIONS[$sectionId]->childLevels = 0;
            unset($SECTIONS[$sectionId]->content);
            unset($SECTIONS[$sectionId]->addedBy);
            unset($SECTIONS[$sectionId]->addedOn);
            unset($SECTIONS[$sectionId]->modifiedBy);
            unset($SECTIONS[$sectionId]->modifiedOn);
            /* section level */
            $SECTIONS[$sectionId]->level = count($SECTIONS[$sectionId]->parents) + 1;
        }

        foreach($SECTIONS as $sectionId=>$section){

            $SECTIONS[$sectionId]->path = $SECTION_PATH;
            if(!empty($section->parents)){
                /* find child sections */
                $SECTIONS[$section->parents[(count($section->parents)-1)]]->children[] = $sectionId;

                /* find all child sections (including children of children) */
                /* build path and url */
                /* count child levels */
                foreach($section->parents as $parentId){

                    /* if templateName is empty, look through parents for subTemplateName */
                    if(empty($section->templateName) && !empty($SECTIONS[$parentId]->subTemplateName)){
                        $section->templateName = $SECTIONS[$sectionId]->templateName = $SECTIONS[$parentId]->subTemplateName;
                    }

                    /* if subTemplateName is empty, look through parents for subTemplateName */
                    if(empty($section->subTemplateName) && !empty($SECTIONS[$parentId]->subTemplateName)){
                        $section->subTemplateName = $SECTIONS[$sectionId]->subTemplateName = $SECTIONS[$parentId]->subTemplateName;
                    }

                    /* if artTemplateName is empty, look through parents for artTemplateName */
                    if (empty($section->artTemplateName) && !empty($SECTIONS[$parentId]->artTemplateName)) {
                        $section->artTemplateName = $SECTIONS[$sectionId]->artTemplateName = $SECTIONS[$parentId]->artTemplateName;
                    }

                    /* if isCached is 0 (use default), look through parents for subIsCached */
                    if ($section->isCached == 0 && $SECTIONS[$parentId]->subIsCached != 0) {
                        if ($SECTIONS[$parentId]->subIsCached == 1) {
                            $section->isCached    = $SECTIONS[$sectionId]->isCached    = $SECTIONS[$parentId]->subIsCached;
                            $section->cacheTime   = $SECTIONS[$sectionId]->cacheTime   = $SECTIONS[$parentId]->subCacheTime;
                            $section->cachePeriod = $SECTIONS[$sectionId]->cachePeriod = $SECTIONS[$parentId]->subCachePeriod;
                        } else if($SECTIONS[$parentId]->subIsCached == -1) {
                            $section->isCached = $SECTIONS[$sectionId]->isCached = -1;
                        }
                    }

                    /* if artIsCached is 0 (use default), look through parents for artIsCached */
                    if ($section->artIsCached == 0 && $SECTIONS[$parentId]->artIsCached != 0) {
                        if($SECTIONS[$parentId]->artIsCached == 1) {
                            $section->artIsCached    = $SECTIONS[$sectionId]->artIsCached    = $SECTIONS[$parentId]->artIsCached;
                            $section->artCacheTime   = $SECTIONS[$sectionId]->artCacheTime   = $SECTIONS[$parentId]->artCacheTime;
                            $section->artCachePeriod = $SECTIONS[$sectionId]->artCachePeriod = $SECTIONS[$parentId]->artCachePeriod;
                        } elseif($SECTIONS[$parentId]->artIsCached == -1) {
                            $section->artIsCached = $SECTIONS[$sectionId]->artIsCached = -1;
                        }
                    }

                    /* if commentsEnabled is 0 (use default), look through parents for subCommentsEnabled */
                    if($section->commentsEnabled == 0 && $SECTIONS[$parentId]->subCommentsEnabled != 0){
                        if($SECTIONS[$parentId]->subCommentsEnabled == 1){
                            $section->commentsEnabled = $SECTIONS[$sectionId]->commentsEnabled = $SECTIONS[$parentId]->subCommentsEnabled;
                        } elseif($SECTIONS[$parentId]->subCommentsEnabled == -1) {
                            $section->commentsEnabled = $SECTIONS[$sectionId]->commentsEnabled = -1;
                        }
                    }

                    $SECTIONS[$parentId]->allChildren[] = $sectionId;
                    $SECTIONS[$sectionId]->path .= '/'.$SECTIONS[$parentId]->fileName;
                    if(empty($SECTIONS[$sectionId]->dir)){
                        $SECTIONS[$sectionId]->dir = $SECTIONS[$parentId]->fileName;
                    } else {
                        $SECTIONS[$sectionId]->dir .= '/'.$SECTIONS[$parentId]->fileName;
                    }
                    if($SECTIONS[$parentId]->childLevels < ($section->level - $SECTIONS[$parentId]->level)){
                        $SECTIONS[$parentId]->childLevels = $section->level - $SECTIONS[$parentId]->level;
                    }
                }
            }

            if(empty($SECTIONS[$sectionId]->dir)){
                $SECTIONS[$sectionId]->dir = $section->fileName;
            } else {
                $SECTIONS[$sectionId]->dir .= '/'.$section->fileName;
            }
            $SECTIONS[$sectionId]->path .= '/'.$section->fileName;
            if ($section->type == 'plain') {
                if ($section->fileName == 'index') {
                    $tmpUrl = $SECTION_PATH.'/';
                } else {
                    $tmpUrl = $SECTIONS[$sectionId]->path.'.'.Config::getValue('file_extension');
                }
            } else {
                $tmpUrl = $SECTIONS[$sectionId]->path.'/';
            }
            if($SECTIONS[$sectionId]->url != $tmpUrl){
                $SECTIONS[$sectionId]->url = $tmpUrl;
                $articleTable = $databaseConfig['prefix'].'articles';
                // TODO: протестировать на сервере
                DB::init()->connect()->table('sections')->where('sectionId', $sectionId)->update(['url'=> $tmpUrl]);
    //                DB::init()->connect()->table('sections')->select()->where('sectionId', '=', $sectionId)->update(['url'=> $tmpUrl]);
                DB::init()->connect()->query("UPDATE  `$articleTable` SET `url` = CONCAT('". $section->path."', '/', fileName, '.". Config::getValue('file_extension') ."') WHERE  `sectionId` = '$sectionId'")->exec();
//                print_r(DB::init()->connect()->getQuery());
    //                dbQuery('sections', DB_UPDATE, array('where'=>"sectionId='$sectionId'", 'values'=>array('url'=>mysql_real_escape_string($tmpUrl))));
    //                dbQuery('articles', DB_UPDATE, array('where'=>"sectionId='$sectionId'", 'values'=>"url=CONCAT('".mysql_real_escape_string($SECTIONS[$sectionId]['path'])."', '/', fileName, '.".mysql_real_escape_string($CONFIG['file_extension'])."')"));
            }
        }

        /* building section tree */
        $links = array();
        $TREE = $SECTIONS;
        foreach($TREE as $sectionId=>$section) $links[$sectionId] = &$TREE[$sectionId];
        foreach($TREE as $sectionId=>$section){
            if(empty($section->hasSubsections)) $links[$sectionId]->hasSubsections = false;
            if($section->parentId > 0){
                $links[$section->parentId]->hasSubsections = true;
                $links[$section->parentId]->subsections[] = $TREE[$sectionId];
                $links[$sectionId] = &$links[$section->parentId]->subsections[count($links[$section->parentId]->subsections) - 1];
                unset($TREE[$sectionId]);
            }
        }

        /* sort the Tree recursively by sortOrder */
        usort($TREE, 'sortBySortOrder');

        /* sort SECTIONS by order of TREE */
        $newSections = array();
        sortAllSections($TREE, $newSections);
        $SECTIONS = $newSections;

        return true;
    }
    function sortAllSections($sections, &$newSections)
    {
        global $SECTIONS;
        foreach($sections as $section){
            $newSections[$section->sectionId] = $SECTIONS[$section->sectionId];
            if(!empty($section->subsections)) sortAllSections($section->subsections, $newSections);
        }
    }
    function getAllParents($sectionId, $parents = array()){

        global $SECTIONS;
        if($SECTIONS[$sectionId]->parentId > 0){
            $parents[] = $SECTIONS[$sectionId]->parentId;
            $parents = getAllParents($SECTIONS[$sectionId]->parentId, $parents);
        }
        return $parents;
    }
    function sortBySortOrder(&$a, &$b): int
    {

        if(!empty($a->subsections)) usort($a->subsections, 'sortBySortOrder');
        if(!empty($b->subsections)) usort($b->subsections, 'sortBySortOrder');
        if ($a == $b) return 0;
        return ($a->sortOrder < $b->sortOrder) ? -1 : 1;
    }


    /**
     * Формирование htaccess
     * @param array $buildLang
     * @return bool
     * @throws SmartyException
     */
    function writeHtaccess($buildLang = array()): bool
    {
        global $smarty, $SECTIONS;

        $rewrite = md5(rand() * time());

        $tmpSmarty = $smarty;

//        $tmpSmarty = new \Mnv\Core\Design();
//        $tmpSmarty->setTemplateDir($smarty->getTemplateDir());
//        $tmpSmarty->setCacheDir($smarty->getCacheDir());
//        $tmpSmarty->setCompileDir($smarty->getCompileDir());
//        $tmpSmarty->setCompileId($smarty->compile_id);
//        $tmpSmarty->defaultModifiers($smarty->default_modifiers);
//
//        $smartyTemplateVars = $smarty->getTemplateVars();
//        foreach($smartyTemplateVars as $key => $value){
//            $tmpSmarty->assign($key, $value);
//        }

        $tmpSmarty->assign('rewrite', $rewrite);
        /* find home page */
        foreach ( $SECTIONS as $section ) {
            if (empty($homePageId)) $homePageId = $section->sectionId;
            if ($section->fileName == 'index') $homePageId = $section->sectionId;
        }
        if ( ! empty($homePageId) ) $tmpSmarty->assign('homePageId', $homePageId);

        if ( empty($buildLang) ) {
            $siteRoot    = SITE_ROOT;
            $htaccessTPL = (SITE_LANG == '' ? 'htaccess.tpl' : 'htaccess-ml.tpl');
        } else {

            $tmpSmarty->assign('SITE_LANG', $buildLang->codename);
            $siteRoot    = ($buildLang->isDefault ? GLOBAL_ROOT : GLOBAL_ROOT.'/'.$buildLang->codename);
            $htaccessTPL = ($buildLang->isDefault ? 'htaccess.tpl' : 'htaccess-ml.tpl');
        }

        $htaccess = $tmpSmarty->fetch(GLOBAL_ROOT . '/admin/templates/' . $htaccessTPL);

        if ( $fh = fopen($siteRoot.'/.htaccess', 'w') ) {
            fwrite($fh, $htaccess);
            fclose($fh);

            /* saving seed */
            $setting['codename'] = 'rewrite';
            $setting['value'] = $rewrite;

            DB::init()->connect()->table('settings')->replace($setting);

            unset($tmpSmarty);
            return true;
        } else {
            return false;
        }


    }

    function buildCurrencyArrays()
    {
        global $CURRENCIES;

        $CURRENCIES = DB::init()->connect()->table('shop_currency')->getAll('array');
    }


    /** Language */

    function buildLanguagesArray(): bool
    {
        global $LANGUAGES;


        $LANGUAGES = DB::init()->connect()->table('languages')->select('languageName, codename, name, url, isDefault, status')->where('status', 'visible')->orderBy('sortOrder')->indexKey('codename')->getAllIndexes();

        $langExport = "<?php\r\n";
        $langExport .= '$LANGUAGES = '. improved_var_export($LANGUAGES, true).";\r\n";
        $langExport .= "return \$LANGUAGES;\r\n";
        $langExport .= "?>";

        saveFile(GLOBAL_ROOT.'/includes/global-languages.inc.php', $langExport);

        foreach($LANGUAGES as $codename => $void) {
            $LANGUAGES[$codename]->languageTransName = lang('languageList:'.$codename);
        }
        return true;
    }


    /**
     *  Translate language variable wrapper (for usage in templates and scripts)
     * @param string $tag
     * @param string|null $default
     * @return array|string
     */
    function __(string $tag, ?string $default = '')
    {
        $text = getTagVal($tag, $default);
        return array2unicode($text);
    }


    function getLanguages(): array
    {
        $languages = array();
        $dh = opendir(GLOBAL_ROOT.'/admin/languages');
        while ($item = readdir($dh)) if ($item != '.' && $item != '..' && $item != '.DS_Store' && is_file(GLOBAL_ROOT."/admin/languages/$item")){
            $L = include(GLOBAL_ROOT."/admin/languages/$item");
            $languages[$L['codeName']] = text2unicode($L['langName'], $L['charset']);
        }
        closedir($dh);
        return array_reverse($languages);
    }


    /**
     * @param $date
     * @return array|string
     */
    function langDate($date) {
        global $L;
        $date = strtr($date, $L['dates']);
        return array2unicode($date);
    }


    /**
     * @param string $tag
     * @param string|null $default
     * @return int
     */
    function langLen(string $tag, ?string $default = ''): int
    {
        $text = getTagVal($tag, $default);
        return strlen($text);
    }

    /**
     * @param string $tag
     * @param string|null $default
     * @return array|string
     */
    function langJs(string $tag, ?string $default = '') {
        $text = getTagVal($tag, $default);
        return array2js($text);
    }

    /**
     * @param string $tag
     * @param string|null $default
     * @return array|string
     */
    function lang(string $tag, ?string $default = '') {
        $text = getTagVal($tag, $default);
        return array2unicode($text);
    }

    /**
     * @param $source
     * @return null|string|string[]
     */
    function replaceLanguageTags($source) {
        global $adminLang, $L;
        if ( !isset($L) ) loadLanguage($adminLang);
        return preg_replace_callback('/{([0-9a-zA-Z_\-:]+?)}/', '_replace_lang_tags_callback', $source);
    }

    /**
     * @param $matches
     * @return array|string
     */
    function _replace_lang_tags_callback($matches) {
        $text = getTagVal($matches[1], $matches[0]);
        return array2unicode($text);
    }

    /**
     * @param $tag
     * @param $default
     * @return mixed
     */
    function getTagVal($tag, $default) {
        global $L;

        $result = '';
        $keys = explode(':', $tag);
        switch (count($keys)) {
            case 1:
                $result = $L[$keys[0]] ?? $default;
                break;
            case 2:
                $result = $L[$keys[0]][$keys[1]] ?? $default;
                break;
            case 3:
                $result = $L[$keys[0]][$keys[1]][$keys[2]] ?? $default;
                break;
            case 4:
                $result = $L[$keys[0]][$keys[1]][$keys[2]][$keys[3]] ?? $default;
                break;
        }

        return $result;
    }

    /**
     * @param $var
     * @return array|string
     */
    function array2js($var) {
        global $L;

        if (is_array($var)) {
            return array_map('array2js', $var);
        } else {
            return text2js($var, $L['charset']);
        }
    }

    /**
     * @param $text
     * @param $encoding
     * @return string
     */
    function text2js($text, $encoding): string
    {
        return text2unicode($text, $encoding);
    }

    /**
     * @param $var
     * @return array|string
     */
    function array2unicode($var) {
        global $L;

        if (is_array($var)) {
            return array_map('array2unicode', $var);
        } else {
            return text2unicode($var, $L['charset']);
        }
    }

    /**
     * @param $text
     * @param $encoding
     * @return string
     */
    function text2unicode($text, $encoding): string
    {
        mb_internal_encoding('UTF-8');
        return mb_convert_encoding($text, 'UTF-8', $encoding);
    }

    /**
     * @param $language
     */
    function loadLanguage($language) {
        global $L;

        if (is_file(GLOBAL_ROOT.'/admin/languages/'.$language.'.inc.php')){
            $L = include(GLOBAL_ROOT.'/admin/languages/'.$language.'.inc.php');
        } else {
            $L = include(GLOBAL_ROOT . '/admin/languages/ru.inc.php');
        }
    }
    /** END Language */

	/**
     * @method gmNow
     * @return false|string
     */
    function gmNow() {
        return gmdate('Y-m-d H:i:s');
    }


    /**
     * Unlink a file, which handles symlinks.
     * @see https://github.com/luyadev/luya/blob/master/core/helpers/FileHelper.php
     * @param string $filename The file path to the file to delete.
     * @return boolean Whether the file has been removed or not.
     */
    function unLinkFile(string $filename) {
        // try to force symlinks
        if (is_link($filename)) {
            $sym = @readlink($filename);
            if ($sym) {
                return is_writable($filename) && @unlink($filename);
            }
        }

        // try to use real path
        if (realpath($filename) && realpath ($filename) !== $filename ) {
            return is_writable ($filename) && @unlink (realpath ($filename));
        }

        // default unlink
        return is_writable ($filename) && @unlink ($filename);
    }

    /**
	 * Создаёт директорию
     * @param $path
     * @return bool
     */
    function makeDir($path) {
    	if (!is_dir($path)) mkdir($path);
    	return true;
    }

    /**
     * @param $fileFrom
     * @param $fileTo
     * @return bool
     */
    function moveFile($fileFrom, $fileTo) {

    	if(!is_file($fileFrom)) return false;
    	if(is_file($fileTo)) @unlink($fileTo);
    	if(copy($fileFrom, $fileTo)) @unlink($fileFrom);
    	return true;
    }
    
    /**
     * @param $pathFrom
     * @param $pathTo
     * @return bool
     */
    function moveDir($pathFrom, $pathTo) {

    	if(!is_dir($pathFrom)) return false;
    	if(!is_dir($pathTo)) @mkdir($pathTo);
    	$pathTo = realpath($pathTo);
    	$pathFrom = realpath($pathFrom);
    	if(!is_dir($pathFrom)) return false;
    	if(!is_dir($pathTo)) @mkdir($pathTo);
    
    	$dh = opendir($pathFrom);
    	while (false !== ($fileName = readdir($dh))) {
    		if($fileName != '.' && $fileName != '..') {
    			$fileNameFrom = "$pathFrom/$fileName";
    			$fileNameTo   = "$pathTo/$fileName";
    			if(is_dir($fileNameFrom)){
    				moveDir($fileNameFrom, $fileNameTo);
    			} else {
    				if(copy($fileNameFrom, $fileNameTo)) @unlink($fileNameFrom);
    			}
    		}
    	}
    	closedir($dh);
    	@rmdir($pathFrom);
    	return true;
    }



	/**
	 * @param $variable
	 * @param false $return
	 * @return string|null
	 */
	function improved_var_export($variable, $return = false) {
		if ($variable instanceof stdClass) {
			$result = '(object) '.improved_var_export(get_object_vars($variable), true);
		} else if (is_array($variable)) {
			$array = array ();
			foreach ($variable as $key => $value) {
				$array[] = var_export($key, true).' => '.improved_var_export($value, true);
			}
			$result = 'array ('.implode(', ', $array).')';
		} else {
			$result = var_export($variable, true);
		}

		if (!$return) {
			print $result;
			return null;
		} else {
			return $result;
		}
	}

    /**
     * копирование папок и их содержимое
     * @param $dir1
     * @param $dir2
     * @param bool $upd
     * @param bool $force
     */
    function copyFolder($dir1, $dir2, $upd = true, $force = true)
    {
        if (is_dir($dir1) ) {
            $dir2 = mkdirSafe($dir2, $force);
            if (!$dir2) {
                fsLog("!!fail $dir2"); return;
            }

            $dir = dir($dir1);

            while (false !== ($entry = $dir->read())) {
                if ($entry != '.' && $entry != '..' && $entry != '.DS_Store')
                    copyFolder("$dir1/$entry", "$dir2/$entry", $upd, $force);
            }

            $dir->close();

        } else {
            $ok = copySafe($dir1, $dir2, $upd);
            $ok = ($ok) ? "ok-- " : " -- ";
            fsLog("{$ok}$dir1");
        }
    }

    /**
     * @param $dir
     * @param $force
     * @return false|mixed
     */
    function mkdirSafe($dir, $force)
    {
        if (file_exists($dir)) {
            if (is_dir($dir)) return $dir;
            else if (!$force) return false;
            unlink($dir);
        }
        return (mkdir($dir, 0775, true)) ? $dir : false;
    }

    /**
     * @param $file1
     * @param $file2
     * @param $upd
     * @return bool
     */
    function copySafe($file1, $file2, $upd)
    {
        $time1 = filemtime($file1);
        if (file_exists($file2)) {
            $time2 = filemtime($file2);
            if ($time2 >= $time1 && $upd) return false;
        }
        $ok = copy($file1, $file2);
        if ($ok) touch($file2, $time1);
        return $ok;
    }

    /**
     * логи при копирование папок, файлов
     * @param $str
     */
    function fsLog($str)
    {
        $log = fopen(GLOBAL_ROOT . "/temp/log/fs_log.txt", "a");
        $time = date("Y-m-d H:i:s");
        fwrite($log, "$str ($time)\n");
        fclose($log);
    }


    /**
     * @param $path
     * @param $content
     * @return bool
     */
    function saveFile($path, $content) {
    	if($fh = fopen($path, 'wb')) {
    		fwrite($fh, $content);
    		fclose($fh);
    		return true;
    	}
    	return false;
    }
    
    /**
     * @param $path
     * @param string $pattern
     * @return array
     */
    function searchDir($path, $pattern = '*.*')
	{
    	$files = array();
    	$dh = opendir($path);
    	$pattern = preg_quote($pattern);
    	$pattern = str_replace('\\*', '.*?', $pattern);
    	while($file = readdir($dh)) if(preg_match("/^$pattern$/i", $file) && $file != '.' && $file != '..') $files[] = $file;
    	sort($files);
    	closedir($dh);
    	return $files;
    }

	/**
	 * @param $file
	 * @return string
	 */
	function getFileSize($file): string
    {
		// ошибка
		if(!file_exists($file)) return "Файл не найден";

		$filesize = filesize($file);
		// Если размер больше 1 Кб
		if($filesize > 1024)
		{
			$filesize = ($filesize/1024);
			// Если размер файла больше Килобайта
			// то лучше отобразить его в Мегабайтах. Пересчитываем в Мб
			if ($filesize > 1024) {
				$filesize = ($filesize/1024);
				// А уж если файл больше 1 Мегабайта, то проверяем
				// Не больше ли он 1 Гигабайта
				if($filesize > 1024) {
					$filesize = ($filesize/1024);
					$filesize = round($filesize, 1);
					return $filesize." ГБ";
				} else {
					$filesize = round($filesize, 1);
					return $filesize." MБ";
				}
			} else {
				$filesize = round($filesize, 1);
				return $filesize." Кб";
			}
		} else {
			$filesize = round($filesize, 1);
			return $filesize." байт";
		}
	}

    /**
     * @param $source
     * @param $dest
     * @param int $permissions
     * @return bool
     */
    function xcopy($source, $dest, $permissions = 0755)
	{
        // Check for symlinks / Проверяет на символические ссылки
        if (is_link($source)) return symlink(readlink($source), $dest);

        // Simple copy for a file / Простая копия для файла
        if (is_file($source)) return copy($source, $dest);

        // Make destination directory / Сделать каталог назначения
        if (!is_dir($dest)) @mkdir($dest, $permissions);

        // Loop through the folder / Цикл по папке
        $dir = dir($source);
        while (false !== $entry = $dir->read()) {
            // Skip pointers / Пропускаем указатели
            if ($entry == '.' || $entry == '..' || $entry == '.DS_Store') {
                continue;
            }

            // Deep copy directories / Углубленные копии каталогов
            xcopy("$source/$entry", "$dest/$entry", $permissions);
        }

        // Clean up
        $dir->close();
        return true;
    }
    
    /**
     * @param $referer
     * @return array
     */
    function parseReferer($referer)
	{
       	$result = array();

    	if (preg_match('|^http|i', $referer)) $result['refererUrl'] = $referer;
    	if (preg_match('|^http://(www\.)?([^/]+)/.*|i', $referer, $matches)) $result['refererWebsite'] = $matches[2];
    	if (preg_match("/^http.+[\?\&](" . Config::getValue('query_fields') . ")=([^\&]+).*/i", $referer, $matches)){
    		$result['searchPhrase'] = urldecode($matches[2]);
    		if (function_exists('mb_detect_order')) {
    			mb_detect_order("UTF-8, " . Config::getValue('charset') . ", ASCII");
    			$encoding = mb_detect_encoding($result['searchPhrase']);
    			$result['searchPhrase'] = ($encoding == 'UTF-8') ? mb_convert_encoding($result['searchPhrase'], Config::getValue('charset'), $encoding) : $result['searchPhrase'];
    		}
    	}
//    	print_r($result);
    	return $result;
    }
    
    /**
     * @param $dirName
     * @return bool
     */
    function deleteDir( $dirName ) {
    	if ( !is_dir($dirName) ) return false;
    	$dh = opendir( $dirName );
    	while (false !== ($fileName = readdir($dh))) {
    		if($fileName != '.' && $fileName != '..'){
    			$fileName = "$dirName/$fileName";
    			if(is_dir($fileName)){
    				deleteDir($fileName);
    			} else {
    				@unlink($fileName);
    			}
    		}
    	}
    	closedir($dh);
    	@rmdir($dirName);
    }

//    /**
//     * @param $srcFileName
//     * @param $dstFileName
//     * @return bool
//     */
//    function gunzipFile($srcFileName, $dstFileName) {
//        $srcH = gzopen($srcFileName, 'rb');
//        $dstH = fopen($dstFileName, 'wb');
//
//        if(!$srcH || !$dstH) return false;
//        while(!gzeof($srcH)) {
//            $buffer = gzread($srcH, 4096);
//            fwrite($dstH, $buffer);
//        }
//
//        gzclose ($srcH);
//        fclose ($dstH);
//
//        return true;
//    }
//
//    /**
//     * @param $srcFileName
//     * @param $dstFileName
//     * @param string $compression
//     * @return bool
//     */
//    function gzipFile($srcFileName, $dstFileName, $compression = '6') {
//        $srcH = fopen($srcFileName, 'rb');
//        $dstH = gzopen($dstFileName, 'wb'.$compression);
//
//        if(!$srcH || !$dstH) return false;
//        while(!feof($srcH)) {
//            $buffer = fgets($srcH, 4096);
//            gzwrite($dstH, $buffer);
//        }
//
//        fclose ($srcH);
//        gzclose ($dstH);
//
//        return true;
//    }
//
//

?>	