<?php
/******************************************************************************/
//                                                                            //
//                             Smarty plugin                                  //
//                            @package Smarty                                 //
//							 @subpackage plugins                              //
//                        http://life-style.uz/                               //
//                   produced by Life Style, life-style.uz                    //
//                                                                            //
/******************************************************************************/

use Mnv\Core\DB;

function smarty_function_fetch_articles($params, &$smarty) {
	global $fetchedArticles;

	$assign        = fetch_getParam('assign', $params, 'articles');
	$fields        = fetch_getParam('fields', $params, 'articleId, sectionId, categoryIds, orderBy, publishedOn, title, alias, url, summary, isFeatured, orderBy, typeContent, videoUrl, icon, urlType, externalLink, address, phones, emails, workingHours, coordinates, placeWork');
	$status        = fetch_getParam('status', $params, 'visible');
	$limit         = (int) fetch_getParam('limit', $params);
	$perPage       = (int) fetch_getParam('perPage', $params, $limit);
	$isFeatured    = fetch_getParam('isFeatured', $params, NULL);
	
	$query         = fetch_getParam('query', $params, NULL);
	$match         = fetch_getParam('match', $params, 'any');
	$order         = fetch_getParam('order', $params, NULL);
	$orderBy       = fetch_getParam('orderBy', $params, $order);
	$section       = fetch_getParam('section', $params);
    $articleId     = fetch_getParam('articleId', $params);
	$typeContent   = fetch_getParam('typeContent', $params);
	$city   = fetch_getParam('city', $params);

	$page          = (int) fetch_getParam('page', $params);
	$skip          = fetch_getParam('skip', $params, NULL);
	$noSubsections = (boolean) fetch_getParam('noSubsections', $params, false);

	$image        = fetch_getParam('image', $params, false);
	$imageType    = fetch_getParam('imageType', $params, 'general');
	
	$sectionInfo  = fetch_getParam('sectionInfo', $params, false);
	$parentsInfo  = fetch_getParam('parentsInfo', $params, false);
	
	$assignPagination = fetch_getParam('assignPagination', $params);
	$path             = fetch_getParam('path', $params);
	$seFriendly       = (boolean) fetch_getParam('seFriendly', $params);
	$pnFirst          = (int) fetch_getParam('pnFirst', $params, 0);
	$pnBefore         = (int) fetch_getParam('pnBefore', $params, 4);
	$pnAfter          = (int) fetch_getParam('pnAfter', $params, 4);
	$pnLast           = (int) fetch_getParam('pnLast', $params, 0);
	
	if (empty($assign)) {
		$smarty->_trigger_fatal_error('fetch_articles: "assign" must not be empty');
		return;
	}
	
	if (empty($path)) $path = array();

    /** calculate article popularity article fields */
    fetch_articles_calculatePopularity($orderBy);

	/** conditions */
    filter($status, $typeContent, $isFeatured, $articleId, $orderBy, $query, $city);

    if (!is_null($query) && is_array($path)) $path[] = "query=".urlencode($query);

    /** query conditions */
    fetch_articles_addQueryConditions($query, $match, $fields, $orderBy);
    /** add section conditions */
    fetch_articles_addSectionConditions($section, $noSubsections);
    /** skipping articles */
    fetch_articles_addSkipConditions($skip);
    /** checking article fields */
    fetch_articles_filterFields($fields);

	if ($page < 1) $page = 1;
	if ($perPage < 1) $perPage = 10;

	if (!is_null($query) && empty($query)) {
		$articles = array();
	} else {
        $articles = DB::init()->connect()->table('articles')->select($fields)->limit(($page-1)*$perPage, $perPage)->getAll();

        $articles = prepareArticles($articles, $sectionInfo, $parentsInfo, $image, $imageType);
	}

//    print_r(DB::init()->connect()->getQuery());
//	print_r($articles);
	$smarty->assign($assign, $articles);

	/* saving fetched articles for SKIP ability */
	if(empty($fetchedArticles[$assign])) $fetchedArticles[$assign] = array();
	if(!empty($articles)) foreach($articles as $article) $fetchedArticles[$assign][] = $article->articleId;
	
	if (!empty($assignPagination)) {

        /** calculate article popularity article fields */
        fetch_articles_calculatePopularity($orderBy);

        /** conditions */
        filter($status, $typeContent, $isFeatured, $articleId, $orderBy, $query, $city);

        if (!is_null($query) && is_array($path)) $path[] = "query=".urlencode($query);

        /** query conditions */
        fetch_articles_addQueryConditions($query, $match, $fields, $orderBy);
        /** add section conditions */
        fetch_articles_addSectionConditions($section, $noSubsections);
        /** skipping articles */
        fetch_articles_addSkipConditions($skip);
        /** checking article fields */
        fetch_articles_filterFields($fields);

        /** page numbering */
        $total = DB::init()->connect()->table('articles')->count('*', 'count')->getValue();
		if (is_array($path)) {
			$path = SITE_URL.'/'.basename($_SERVER['PHP_SELF']).'?'.(!empty($path) ? implode('&', $path).'&' : '');
			$seFriendly = false;
		}
		$pagination = getPageNums($total, $page, $perPage, $pnFirst, $pnBefore, $pnAfter, $pnLast, $path, $seFriendly);
		$smarty->assign($assignPagination, $pagination);
	}
	
	return null;
}

function filter($status, $typeContent, $isFeatured, $articleId, $orderBy, $query, $city)
{
    global $gmNow;

    DB::init()->connect()->where('publishedOn','<=', $gmNow);
    if (!empty($status)) DB::init()->connect()->where('status', $status);
    if (!empty($typeContent)) DB::init()->connect()->where('typeContent', $typeContent);
    if (!is_null($isFeatured)) DB::init()->connect()->where('isFeatured', $isFeatured ? 1 : 0);
    if (!empty($articleId)) DB::init()->connect()->where('articleId', '!=', $articleId);
    if (!empty($city)) DB::init()->connect()->where('placeWork', $city);
    if (is_null($orderBy)) {
        DB::init()->connect()->orderBy(is_null($query) ? 'publishedOn DESC' : '');
    } else {
        DB::init()->connect()->orderBy($orderBy);
    }
}

?>