<?php
/******************************************************************************/
//                                                                            //
//                             Smarty plugin                                  //
//                            @package Smarty                                 //
//							 @subpackage plugins                              //
//                        http://life-style.uz/                               //
//                   produced by Life Style, life-style.uz                    //
//                                                                            //
/******************************************************************************/

use Mnv\Core\DB;
use Mnv\Models\Variants;

function smarty_function_fetch_products($params, &$smarty){
	global $gmNow, $fetchedArticles;

	$assign        = fetch_getParam('assign', $params, 'products');
	$fields        = fetch_getParam('fields', $params, 'articleId, sectionId, publishedOn, title, alias, url, summary, isFeatured, typeContent, special, brand, counter, id AS variantId, name, sku, price, oldPrice, stock');
	$status        = fetch_getParam('status', $params, 'visible');
	$limit         = (int) fetch_getParam('limit', $params);
	$perPage       = (int) fetch_getParam('perPage', $params, $limit);
	$isFeatured    = fetch_getParam('isFeatured', $params, NULL);
	
	$query         = fetch_getParam('query', $params, NULL);
	$match         = fetch_getParam('match', $params, 'any');
	$order         = fetch_getParam('order', $params, NULL);
	$orderBy       = fetch_getParam('orderBy', $params, $order);
	$section       = fetch_getParam('section', $params);
    $articleId     = fetch_getParam('articleId', $params);
	$page          = (int) fetch_getParam('page', $params);
	$skip          = fetch_getParam('skip', $params, NULL);
	$noSubsections = (boolean) fetch_getParam('noSubsections', $params, false);
	
	$image        = fetch_getParam('image', $params, false);
	$imageType   = fetch_getParam('imageType', $params, 'general');
	
	$sectionInfo  = fetch_getParam('sectionInfo', $params, false);
	$parentsInfo  = fetch_getParam('parentsInfo', $params, false);

    $special        = fetch_getParam('special', $params, '');
    if (!empty($special)) {
        $special = explode(",", $special);
        remove_from_array("all", $special, false);
    }

    $brand          = fetch_getParam('brand', $params, '');
    if (!empty($brand)) $brand = explode(",", $brand);

	$minPrice 		= (int) fetch_getParam('minPrice', $params, '');
	$maxPrice 		= (int) fetch_getParam('maxPrice', $params, '');
	
	
	$assignPagination = fetch_getParam('assignPagination', $params);
	$path             = fetch_getParam('path', $params);
	$seFriendly       = (boolean) fetch_getParam('seFriendly', $params);
	$pnFirst          = (int) fetch_getParam('pnFirst', $params, 0);
	$pnBefore         = (int) fetch_getParam('pnBefore', $params, 4);
	$pnAfter          = (int) fetch_getParam('pnAfter', $params, 4);
	$pnLast           = (int) fetch_getParam('pnLast', $params, 0);
	
	if (empty($assign)) {
		$smarty->_trigger_fatal_error('fetch_products: "assign" must not be empty');
		return;
	}
    $features = new \Mnv\Models\Features();

	if (empty($path)) $path = array();

    /** calculate article popularity article fields */
    if (!empty($orderBy) && $orderBy == 'popularity') $orderBy = 'popularityLast7days';
    fetch_articles_calculatePopularity($orderBy);

	/** conditions */
    DB::init()->connect()->where('publishedOn','<=', $gmNow);
    DB::init()->connect()->where('typeContent', 'products');
	if (!empty($status))    DB::init()->connect()->where('status','=', $status);
    if (!empty($articleId)) DB::init()->connect()->where('articleId', '!=', $articleId);
    if (!empty($brand))     DB::init()->connect()->in('brand', $brand);
    if (!empty($special))   DB::init()->connect()->in('special', $special);
    if (!empty($minPrice) && !empty($maxPrice)) DB::init()->connect()->between('price', $minPrice, $maxPrice);
	if (!is_null($isFeatured)) DB::init()->connect()->where('isFeatured','=',$isFeatured ? 1 : 0);

	if (empty($orderBy)) {
        DB::init()->connect()->orderBy(is_null($query) ? 'publishedOn DESC' : 'articleId DESC');
    } else {
        if ($orderBy == 'popularity') {
            DB::init()->connect()->orderBy('popularityLast7days DESC');
        } else if ($orderBy == 'min') {
            DB::init()->connect()->orderBy('price ASC');
        } else if ($orderBy == 'max') {
            DB::init()->connect()->orderBy('price DESC');
        } else if ($orderBy == 'rating') {
            DB::init()->connect()->orderBy('rating DESC');
        } else {
            DB::init()->connect()->orderBy($orderBy);
        }
    }

	if (!is_null($query) && is_array($path)) $path[] = "query=".urlencode($query);

	/** query conditions */
	fetch_articles_addQueryConditions($query, $match, $fields, $orderBy);
	/** add section conditions */
	fetch_articles_addSectionConditions($section, $noSubsections);
	/** skipping articles */
	fetch_articles_addSkipConditions($skip);
    /** checking article fields */
    fetch_articles_filterFields($fields);

	if ($page < 1) $page = 1;
	if ($perPage < 1) $perPage = 10;

	if (!is_null($query) && empty($query)) {
		$products = array();
	} else {
        $products = DB::init()->connect()->table('articles')->select($fields)->join('product_variants', 'productId', 'articleId')->pagination($perPage, $page)->indexkey('articleId')->groupBy('productId')->getAllIndexes();
//        print_r(DB::init()->connect()->getQuery());
//        print_r($products);
        if ($products) {
            $products = prepareArticles($products, $sectionInfo, $parentsInfo, $image, $imageType);

            foreach ($products as $key => $product) {
//            $products[$key]->variants = DB::init()->connect()->table('product_variants')->select('id, name, sku, price, oldPrice, stock')->where('productId', $product->articleId)->getAll();
                $products[$key]->features = $features->getProductOptions($product->articleId);
                if (!empty($product->content) && stristr($product->content, '{PAGEBREAK}') !== false) {
                    $products[$key]->content = explode('{PAGEBREAK}', $product->content);
                }
            }
        }

	}

//    print_r($products);
	$smarty->assign($assign, $products);

	/** saving fetched articles for SKIP ability */
	if(empty($fetchedArticles[$assign])) $fetchedArticles[$assign] = array();
	if(!empty($articles)) foreach($articles as $article) $fetchedArticles[$assign][] = $article->articleId;

    /** Pagination */
	if (!empty($assignPagination)) {

        /** calculate article popularity article fields */
        fetch_articles_calculatePopularity($orderBy);

	    DB::init()->connect()->where('publishedOn','<=', $gmNow);
        DB::init()->connect()->where('typeContent','=', 'products');
        if (!empty($status))    DB::init()->connect()->where('status','=', $status);
        if (!empty($articleId)) DB::init()->connect()->where('articleId', '!=', $articleId);
        if (!empty($brand))     DB::init()->connect()->in('brand', $brand);
        if (!empty($special))   DB::init()->connect()->in('special', $special);
        if(!empty($minPrice) && !empty($maxPrice)) DB::init()->connect()->between('price', $minPrice, $maxPrice);
        if (!is_null($isFeatured)) DB::init()->connect()->where('isFeatured','=',$isFeatured ? 1 : 0);
        if (empty($orderBy)) {
            DB::init()->connect()->orderBy(is_null($query) ? 'publishedOn DESC' : 'articleId DESC');
        } else {
            if ($orderBy == 'popularity') {
                DB::init()->connect()->orderBy('popularityLast7days DESC');
            } else if ($orderBy == 'min') {
                DB::init()->connect()->orderBy('price ASC');
            } else if ($orderBy == 'max') {
                DB::init()->connect()->orderBy('price DESC');
            } else if ($orderBy == 'rating') {
                DB::init()->connect()->orderBy('rating DESC');
            } else {
                DB::init()->connect()->orderBy($orderBy);
            }
        }

        if (!is_null($query) && is_array($path)) $path[] = "query=".urlencode($query);

        /** query conditions */
        fetch_articles_addQueryConditions($query, $match, $fields, $orderBy);
        /** add section conditions */
        fetch_articles_addSectionConditions($section, $noSubsections);
        /** skipping articles */
        fetch_articles_addSkipConditions($skip);
        /** checking article fields */
        fetch_articles_filterFields($fields);

        $total = DB::init()->connect()->table('articles')->count('*', 'count')->join('product_variants', 'productId', '=', 'articleId')->getValue();
        /** page numbering */
		if (is_array($path)) {
			$path = SITE_URL.'/'.basename($_SERVER['PHP_SELF']).'?'.(!empty($path) ? implode('&', $path).'&' : '');
			$seFriendly = false;
		}
		$pagination = getPageNums($total, $page, $perPage, $pnFirst, $pnBefore, $pnAfter, $pnLast, $path, $seFriendly);
		$smarty->assign($assignPagination, $pagination);
	}
	
	return null;
}


?>