<?php


use Mnv\Core\DB;

class PayBoxApi
{

    /**
     * Идентификатор мерчанта в PayBox.money. Выдается при подключении.
     * @var string
     */
    const MERCHANTID = '542619';

    /**
     * Время (в секундах) в течение которого платеж должен быть завершен
     *
     * @var int
     * Default: "86400"
     * Минимально допустимое значение: 300 секунд (5 минут).
     * Максимально допустимое значение: 604800 секунд (7 суток)
     */
    const TRANSACTION_LIFETIME = 300;

    /**
     * Секретный ключ для приема платежей
     */
    const SECTETKEY = 'fGs7tiztCCgMRCWm';

    /**
     * Секретный ключ для выплат клиентам
     */
    const SECTETKEYPAYOUT = 'WS29lxdLF2ALHTI1';

    /**
     * @var string sandbox/life
     */
    const MODE = 'sandbox';

    /**
     * Валюта, в которой указана сумма. KZT, USD, EUR.
     * В случае выбора покупателем способа платежа в другой валюте, производится пересчет по курсу ЦБ на день платежа.
     *
     * @var $currency
     */
    public $currency;

    /**
     * Идентификатор платёжной системы. EPAYWEBKZT
     * @var $payment_system
     */
    public $payment_system;

    public $order;
    public $payment;
    public $product;

    public function __construct()
    {
        parent::__construct();

        $this->payment_system = '';
    }


    public function getOrder($orderId)
    {
        $this->order = DB::init()->connect()->table('shop_orders')->select('id, basketId, amount, status, state')->where('id',  $orderId)->get();
        $this->order->products = DB::init()->connect()->table('shop_basket')->select('products')->where('basketId', $this->order->basketId)->getValue();
        $this->order->products = json_decode($this->order->products);

    }

    public function checkOrder($orderId)
    {
        if (DB::init()->connect()->table('shop_orders')->where('id', $orderId)->get()) return true;

        return false;
    }

    public function updateOrder($orderId, $status, $state)
    {
        $params['status'] = $status;
        $params['state'] = $state;
        if (DB::init()->connect()->table('shop_orders')->select('products')->where('id', $orderId)->update($params)) return true;

        return false;
    }

    public function getProducts($productId)
    {
        return DB::init()->connect()->table('shop_orders')->select('articleId, title')->where('articleId', $productId)->get();
    }

    public function getDefaultCurrency()
    {

        $this->currency = DB::init()->connect()->table('shop_currency')->select('codeName')->where('isDefault', 1)->getValue();
    }

    /**
     * @param $amount
     * @return float|mixed
     */
    public function convertMoney($amount)
    {
        if ($course = DB::init()->connect()->table('shop_currency')->select('course')->where('codeName', $this->currency)->getValue())
        {
            return round($amount / $course,2);
        }

        return $amount;

    }
}