<?php

use Mnv\Core\Config;

require_once "../includes/visitor.inc.php";

global $smarty, $siteApp;

$rewrite   = getRequestVar('rewrite');
$action     = getRequestVar('action', '');
$order      = getRequestVar('order', '', true);
$amount     = (int) getRequestVar('amount', 0);
$quantity   = (int) getRequestVar('quantity', 0);
$productId  = (int) getRequestVar('id', 0);

$result   = array();
$count = 0;

if ($rewrite != Config::getValue('rewrite')) {
    header("HTTP/1.0 301 Moved Permanently");
    header("Location: " . SITE_URL);

    /* saving visit */
    writeErrorVisit(301);
    exit;
}

if ($action == 'favorite') {
    $favorite = new \Mnv\Modules\Favorites();

    if (!empty($id) && $id > 0) {
        $error = $favorite->setId($id);
        $siteApp->success = $error ? $error : ['result' => true];
    }

    if (!empty($siteApp->errors)) $result = array('status' => 400, 'message' => $siteApp->errors, 'count' => $favorite->countFavorite);
    if (!empty($siteApp->success)) $result = array('status' => 200, 'message' => $siteApp->success, 'count' => $favorite->countFavorite);

    return response()->json($result, \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => 'utf-8'], JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES | JSON_PRETTY_PRINT)->send();
} else if ($action == 'compare') {
//    case 'compare':
//        if (!empty($id)) {
//            if (isset($userId) && !empty($userId)) {
//                if ($siteApp->is_compares($id, $userId)) {
//                    if ($siteApp->remove_compare($id, $userId)) $siteApp->success = 'Removed from comparison!';
//                } else {
//                    if ($siteApp->add_compares($id, $userId)) $siteApp->success = 'Added for comparison!';
//                }
//            } else {
//                if (Cookie::exists($siteApp->_cookie_compare_name) && Cookie::get($siteApp->_cookie_compare_name)) {
//                    $tmp = Cookie::get($siteApp->_cookie_compare_name);
//                    $tmp = explode(',', $tmp);
//                    if (!in_array($id, $tmp)) {
//                        if (array_push($tmp, $id)) {
//                            Cookie::set($siteApp->_cookie_compare_name, implode(',', $tmp), $siteApp::$COOKIE_EXPIRY);
//                            $siteApp->success = 'Added to compare array_push!';
//                        } else {
//                            $siteApp->errors = 'Not added to compare array_push';
//                        }
//                    } else {
//                        if ($tmp = array_diff($tmp, [$id])) {
//                            Cookie::set($siteApp->_cookie_compare_name, implode(',', $tmp), $siteApp::$COOKIE_EXPIRY);
//                            $siteApp->success = 'Added to compare array_diff!';
//                        } else {
//                            Cookie::delete($siteApp->_cookie_compare_name);
//                            $siteApp->errors = 'Not added to compare array_diff';
//                        }
//                    }
//
//                } elseif (Cookie::set($siteApp->_cookie_compare_name, $id, $siteApp::$COOKIE_EXPIRY)) {
//                    $siteApp->success = 'Added to compare!';
//                } else {
//                    $siteApp->errors = 'Not added to compare';
//                }
//            }
//        } else {
//            $siteApp->errors = 'Not ID product';
//        }
//        if (!empty($siteApp->errors)) $result = array('code' => false, 'info' => $siteApp->errors);
//        if (!empty($siteApp->success)) $result = array('code' => true, 'info' => $siteApp->success);
//        jsonResponse($result);
//        break;
//} else if ($action == 'compare_count') {
//    case 'compare_count':
//        if (isset($userId) && !empty($userId)) {
//            $count = $siteApp->count_compare($userId);
//            jsonResponse($count);
//        }
} else if ($action == 'add_to_cart') {
        if (!empty($productId)) {

            if ($product = $siteApp->check_shopping_cart()) {
                if ($siteApp->add_to_basket($productId, $quantity)) {
                    $siteApp->success = 'Product added to cart!';
                } else {
                    $siteApp->errors = 'Product not added to cart!';
                }
            } else {
                if ($siteApp->add_to_basket($productId, $quantity)) {
                    $siteApp->success = 'Product added to cart!';
                } else {
                    $siteApp->errors = 'Product not added to cart!';
                }
            }
        }
        if (!empty($siteApp->errors)) $result = array('code' => false, 'info' => $siteApp->errors);
        if (!empty($siteApp->success)) $result = array('code' => true, 'info' => $siteApp->success);

        return response()->json($result, \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => 'utf-8'], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES|JSON_PRETTY_PRINT)->send();
} else if ($action == 'minus' || $action == 'plus' || $action == 'amount_input_product') {
            if ($product = $siteApp->get_product_basket($productId)) {
                if (empty($product->variants->stock) || $product->variants->stock > 0) {
                    if ($quantity == 0) {
                        $siteApp->remove_product_basket($productId);
                    } else {
                        if ($quantity = min($quantity, ($product->variants->stock ? $product->variants->stock : $quantity))) {

                            $siteApp->update_basket($productId, $quantity);
                            $product = $siteApp->get_product_basket($productId);
                            $total_amount = $product["price"] * (int)$product['amount'];
                            $siteApp->success = 'Product added to cart';

                        } else {
                            $siteApp->errors = 'There is no such quantity of goods in stock!';
                        }
                    }
                }
            } else {
                $siteApp->errors = 'There is no such product';
            }

        if (!empty($siteApp->errors)) $result = array('code' => false, 'info' => $siteApp->errors);
        if (!empty($siteApp->success)) $result = array('code' => true, 'info' => $siteApp->success, 'subtotal' => $siteApp->price_format($total_amount));

    return response()->json($result, \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => 'utf-8'], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES|JSON_PRETTY_PRINT)->send();

} else if ($action == 'remove_product') {
            if ($siteApp->remove_product_basket($productId)) {
                $siteApp->success = 'Product removed!';
            } else {
                $siteApp->errors = 'Product not removed!';
            }
        if (!empty($siteApp->errors)) $result = array('code' => false, 'info' => $siteApp->errors);
        if (!empty($siteApp->success)) $result = array('code' => true, 'info' => $siteApp->success);

        return response()->json($result, \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => 'utf-8'], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES|JSON_PRETTY_PRINT)->send();
} else if ($action == 'remove_all_products') {
        if ($siteApp->remove_all_products_basket()) {
            $siteApp->success = 'All items removed from cart!';
        } else {
            $siteApp->errors = 'Product not removed!';
        }
        if (!empty($siteApp->errors)) $result = array('code' => false, 'info' => $siteApp->errors);
        if (!empty($siteApp->success)) $result = array('code' => true, 'info' => $siteApp->success);

        return response()->json($result, \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => 'utf-8'], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES|JSON_PRETTY_PRINT)->send();

} else if ($action == 'cart_products_count') {
        $count = $siteApp->products_count_basket();
        $result = array('code' => true, 'count' => $count);
        return  response()->json($result, \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => 'utf-8'], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES|JSON_PRETTY_PRINT)->send();
} else if ($action == 'cart_total_price') {
    $price = $siteApp->total_price_basket();
    $result = array('code' => true, 'amount' => number_format($price, 0, '.', ' ') . ' сум');

    return  response()->json($result, \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => 'utf-8'], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES|JSON_PRETTY_PRINT)->send();

        // TODO: 1 добавление товара если пользователь не зарегистрирован.
        // TODO: 2 список товара, удаление, в header (корзина),
        // TODO: 3 подгрузка товара в модальное окно при добавление товара в корзину

}