<?php

include '../includes/overall.inc.php';

use Mnv\Core\Config;
use Mnv\Core\Feedback;
use Mnv\Core\Locale\I18N;

global $smarty;
	
	$feedbackClass = new Feedback(Config::getValue('mail_transport'));
    $feedbackClass->getCaptchaEnabled(Config::getValue('feedback_captcha_enabled'));
    $feedbackClass->getAllowCaptcha(Config::getValue('allow_recaptcha'));
    $feedbackClass->telegram(Config::getValue('telegram_send'));

    $error    = '';
    $response  = null;
    $captchaGood = false;
    $attachment = null;

    $rewrite   = getRequestVar('rewrite');
    $feedback   = getRequestVar('feedback', '', true);
    $bot        = getRequestVar('bot', '', true);


    if ($rewrite != Config::getValue('rewrite')) {
        header("HTTP/1.0 301 Moved Permanently");
        header("Location: " . SITE_URL);

        /* saving visit */
        writeErrorVisit(301);
        exit;
    }

    /* checking whether message is empty */
    if (empty($feedback['subject']))  $feedback['subject'] = Config::getValue('smtp_subject');
    $feedback['subject'] = preg_replace("/(%0A|%0D|\n|\r)/i", '', trim($feedback['subject']));

//    /* checking whether message is empty */
//    if (isset($feedback['fullName'])) {
//        $feedback['fullName'] = preg_replace("/(%0A|%0D|\n|\r)/i", '', trim($feedback['fullName']));
//        if (empty($feedback['fullName'])) $feedbackClass->errors = 'fullName';
//        $feedbackClass->checkName($feedback['fullName']);
//    } else {
//        $feedback['fullName'] = null;
//    }

    $feedback['dealer'] = preg_replace("/(%0A|%0D|\n|\r)/i", '', trim($feedback['dealer']));
    if (empty($feedback['dealer'])) $feedbackClass->errors = 'dealer';

    $feedback['phone'] = preg_replace("/(%0A|%0D|\n|\r)/i", '', trim($feedback['phone']));
    if (empty($feedback['phone'])) $feedbackClass->errors = 'phone';

    $arrayMessage = array_filter([
        'Дата отправки сообщения' => adjustTime(gmdate('d-m-Y H:i'), false, 'd-m-Y H:i'),
        'Дилер'        => $feedback['dealer'],
        'Телефон'       => $feedback['phone']
    ]);

    $txt = "<b>" . $feedback['subject'] . "</b>%0A";
    foreach($arrayMessage as $key => $value) {
        $txt .= "<b>".$key.":</b> ".$value."%0A";
    }

    $htmlBody = '';
    foreach($arrayMessage as $key => $value) {
        $htmlBody .= "<b>".$key.":</b> ".$value."<br/>";
    }

    if (empty($feedbackClass->errors)) {
        /* проверка включена капча */
        if ($feedbackClass->setCaptchaEnabled() == 1) {
            /* вид капчи */
            if ($feedbackClass->setAllowCaptcha() == 1) {
                if (empty($feedbackClass->errors) && $feedbackClass->captchaToken($_POST['token'])) {
                    $captchaGood = true;
                } else {
                    $response = array('status' => 400, 'message' => $feedbackClass->errors, 'color' => 'red');
                }
            } else {
                if (empty($feedbackClass->errors) && $feedbackClass->antiBot($bot['anti-bot-a'], $bot['anti-bot-q'], $bot['anti-email'])) {
                    $captchaGood = true;
                } else {
                    $response = array('status' => 400, 'message' => $feedbackClass->errors, 'color' => 'red');
                }
            }
        }
        /* если все good то пропускаем на отправку */
        if (empty($feedbackClass->errors) && $captchaGood == true) {
            /* отправка в телеграм */
            $feedbackClass->sendTelegram($txt);
            /* отправка по smtp */
            try {
                if (empty($feedbackClass->errors) && $feedbackClass->send(Config::getValue('email'), Config::getValue('company_name'), null, null, $feedback['subject'], $htmlBody, null)) {
                    $response = array(
                        'status' => 200, 'color' => 'green',
                        'message' => I18N::locale("Ваше сообщение успешно отправлено", "Sizning xabaringiz muvaffaqiyatli yuborildi", "Your message has been sent successfully")
                    );
                    $feedbackClass->insertMail($feedback['email'] ?? 'Email не указан', $feedback['fullName'] ?? 'Ф.И.О. не указан', $feedback['phone'], $feedback['subject'], $htmlBody);
                } else {
                    $response = array('status' => 400, 'message' => $feedbackClass->errors, 'color' => 'red');
                }
            } catch (\PHPMailer\PHPMailer\Exception $e) {
                $response = array('status' => 400, 'message' => $e->getMessage(), 'color' => 'red');
            }
        }
    } else {
        $response = array('status' => 400, 'message' => $feedbackClass->errors, 'color' => 'red');
    }


    return response()->json($response, \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => 'utf-8'], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES|JSON_PRETTY_PRINT)->send();
  

