<?php

use Mnv\Core\Config;
use Mnv\Modules\Favorites;

require_once "../includes/visitor.inc.php";

global $smarty, $siteApp;

$rewrite   = getRequestVar('rewrite');


$action     = getRequestVar('action', '');
$order      = getRequestVar('order', '', true);

$quantity   = (int) getRequestVar('quantity', 0);
$variant    = (int) getRequestVar('variant', 0);

$result   = array();
$count = 0;

if ($rewrite != Config::getValue('rewrite')) {
    header("HTTP/1.0 301 Moved Permanently");
    header("Location: " . SITE_URL);

    /* saving visit */
    writeErrorVisit(301);
    exit;
}

// TODO: оптимизировать корзину
if  ($action == 'favorite') {
    $favorite = new Favorites();

    if (!empty($id) && $id > 0) {
        $error = $favorite->setId($id);
        $siteApp->success = $error ? $error : ['result' => true];
    }

    if (!empty($siteApp->errors)) $result = array('status' => 400, 'message' => $siteApp->errors, 'count' => $favorite->countFavorite);
    if (!empty($siteApp->success)) $result = array('status' => 200, 'message' => $siteApp->success, 'count' => $favorite->countFavorite);

    return response()->json($result, \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => 'utf-8'], JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES | JSON_PRETTY_PRINT)->send();
} else if  ($action == 'add_to_cart') {
        if (!empty($variant)) {
            if ($siteApp->add_to_basket($variant, $quantity)) {
                $siteApp->success = 'Product added to cart!';
            } else {
                $siteApp->errors = 'Product not added to cart!';
            }
        }
        if (!empty($siteApp->errors)) $result = array('code' => false, 'info' => $siteApp->errors);
        if (!empty($siteApp->success)) $result = array('code' => true, 'info' => $siteApp->success);

        return response()->json($result, \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => 'utf-8'], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES|JSON_PRETTY_PRINT)->send();
} else if  ($action == 'minus' || $action == 'plus' || $action == 'amount_input_product') {
            if ($product = $siteApp->get_product_basket($variant)) {
//                print_r($product);
                if (empty($product->stock) || $product->stock > 0) {
                    if ($quantity == 0) {
                        $siteApp->remove_product_basket($variant);
                    } else {
                        if ($quantity = min($quantity, ($product->stock ? $product->stock : $quantity))) {

                            $siteApp->update_basket($variant, $quantity);
//                            $product = $siteApp->get_product_basket($variant);
//                            $total_amount = $product["price"] * (int)$product['amount'];
                            $siteApp->success = 'Product added to cart';

                        } else {
                            $siteApp->errors = 'There is no such quantity of goods in stock!';
                        }
                    }
                }
            } else {
                $siteApp->errors = 'There is no such product';
            }

        if (!empty($siteApp->errors)) $result = array('code' => false, 'info' => $siteApp->errors);
//        if (!empty($siteApp->success)) $result = array('code' => true, 'info' => $siteApp->success, 'subtotal' => $siteApp->price_format($total_amount));

    return response()->json($result, \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => 'utf-8'], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES|JSON_PRETTY_PRINT)->send();

} else if  ($action == 'remove_product') {
            if ($siteApp->remove_product_basket($variant)) {
                $siteApp->success = 'Product removed!';
            } else {
                $siteApp->errors = 'Product not removed!';
            }
        if (!empty($siteApp->errors)) $result = array('code' => false, 'info' => $siteApp->errors);
        if (!empty($siteApp->success)) $result = array('code' => true, 'info' => $siteApp->success);

        return response()->json($result, \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => 'utf-8'], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES|JSON_PRETTY_PRINT)->send();
} else if  ($action == 'remove_all_products') {

        if ($siteApp->remove_all_products_basket()) {
            $siteApp->success = 'All items removed from cart!';
        } else {
            $siteApp->errors = 'Product not removed!';
        }
        if (!empty($siteApp->errors)) $result = array('code' => false, 'info' => $siteApp->errors);
        if (!empty($siteApp->success)) $result = array('code' => true, 'info' => $siteApp->success);

        return response()->json($result, \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => 'utf-8'], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES|JSON_PRETTY_PRINT)->send();

} else if  ($action == 'cart_products_count') {
        $count = $siteApp->products_count_basket();
        $result = array('code' => true, 'count' => $count);
        return response()->json($result, \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => 'utf-8'], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES|JSON_PRETTY_PRINT)->send();
 } else if  ($action == 'cart_total_price') {

    $price = $siteApp->total_price_basket();
    $result = array('code' => true, 'amount' => number_format($price, 0, '.', ' ') . ' сум');

    return   response()->json($result, \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => 'utf-8'], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES|JSON_PRETTY_PRINT)->send();

        // TODO: 1 добавление товара если пользователь не зарегистрирован.
        // TODO: 2 список товара, удаление, в header (корзина),
        // TODO: 3 подгрузка товара в модальное окно при добавление товара в корзину

}