<?php
	include '../includes/overall.inc.php';

use Mnv\Core\Config;
use Mnv\Core\Feedback;
use Mnv\Core\Locale\I18N;

global $smarty;
	
	$feedbackClass = new Feedback(Config::getValue('mail_transport'));
    $feedbackClass->getCaptchaEnabled(Config::getValue('feedback_captcha_enabled'));
    $feedbackClass->getAllowCaptcha(Config::getValue('allow_recaptcha'));
    $feedbackClass->telegram(Config::getValue('telegram_send'));

    $error    = '';
    $response  = null;
    $captchaGood = false;
    $attachment = null;

    $rewrite   = getRequestVar('rewrite');
    $feedback   = getRequestVar('feedback', '', true);
    $bot        = getRequestVar('bot', '', true);


    if ($rewrite != Config::getValue('rewrite')) {
        header("HTTP/1.0 301 Moved Permanently");
        header("Location: " . SITE_URL);

        exit;
    }

//    print_r($feedback);
//    print_r("FILES");
//    print_r($_FILES);
//    print_r("POST");
//    print_r($_POST);


//    if (isset($_FILES['file'])) {
//        if ($_FILES['file']['size'] > Config::getValue('max_file_size')) $feedbackClass->errors = 'max_file_size';
//    }
    if (isset($_FILES)) {
        if (!empty($_FILES['file'])) $attachment =  $_FILES['file'];
    }

    if (isset($feedback['email'])) {
        if (!$feedbackClass->validationEmail($feedback['email'])) $feedbackClass->errors = 'email';
    } else {
        $feedback['email'] = null;
    }

    if (empty($feedback['subject']))  $feedback['subject'] = Config::getValue('smtp_subject');
    $feedback['subject'] = preg_replace("/(%0A|%0D|\n|\r)/i", '', trim($feedback['subject']));


    if (isset($feedback['firstName'])) {
        $feedback['firstName'] = preg_replace("/(%0A|%0D|\n|\r)/i", '', trim($feedback['firstName']));
        if (empty($feedback['firstName'])) $feedbackClass->errors = 'firstName';
        $feedbackClass->checkName($feedback['firstName']);
    } else {
        $feedback['firstName'] = null;
    }

    if (isset($feedback['lastName'])) {
        $feedback['lastName'] = preg_replace("/(%0A|%0D|\n|\r)/i", '', trim($feedback['lastName']));
        if (empty($feedback['lastName'])) $feedbackClass->errors = 'lastName';
        $feedbackClass->checkName($feedback['lastName']);
    } else {
        $feedback['lastName'] = null;
    }

    $feedback['fullName'] = $feedback['firstName'] . ' ' . $feedback['lastName'];

    $feedback['phone'] = preg_replace("/(%0A|%0D|\n|\r)/i", '', trim($feedback['phone']));
    if (empty($feedback['phone'])) $feedbackClass->errors = 'phone';


    if (isset($feedback['vacancy'])) {
        $feedback['vacancy'] = preg_replace("/(%0A|%0D|\n|\r)/i", '', trim($feedback['vacancy']));
        if (empty($feedback['vacancy'])) $feedbackClass->errors = 'vacancy';
    } else {
        $feedback['vacancy'] = null;
    }

    if (isset($feedback['city'])) {
        $feedback['city'] = preg_replace("/(%0A|%0D|\n|\r)/i", '', trim($feedback['city']));
        if (empty($feedback['city'])) $feedbackClass->errors = 'city';
    } else {
        $feedback['city'] = null;
    }

/* checking whether message is empty */
//    if (empty($feedback['message'])) $feedbackClass->errors = 'message';


    $arrayMessage = array_filter([
        'Дата отправки сообщения' => adjustTime(gmdate('d-m-Y H:i'), false, 'd-m-Y H:i'),
        'Ф.И.О.'        => $feedback['fullName'],
        'Телефон'       => $feedback['phone'],
        'Емайл'         => $feedback['email'],
        'Вакансия'      => $feedback['vacancy'],
        'Город'         => $feedback['city'],
        'Сообщение'     => $feedback['message'] ?? null
    ]);

    $txt = "<b>" . $feedback['subject'] . "</b>%0A";
    foreach($arrayMessage as $key => $value) {
        $txt .= "<b>".$key.":</b> ".$value."%0A";
    }

    $htmlBody = '';
    foreach($arrayMessage as $key => $value) {
        $htmlBody .= "<b>".$key.":</b> ".$value."<br/>";
    }

    if (empty($feedbackClass->errors)) {

        /* проверка включена капча */
        if ($feedbackClass->setCaptchaEnabled() == 1) {
            /* вид капчи */
            if ($feedbackClass->setAllowCaptcha() == 1) {
                if (empty($feedbackClass->errors) && $feedbackClass->captchaToken($_POST['token'])) {
                    $captchaGood = true;
                } else {
                    $response = array('status' => 400, 'message' => $feedbackClass->errors, 'color' => 'red');
                }
            } else {
                if (empty($feedbackClass->errors) && $feedbackClass->antiBot($bot['anti-bot-a'], $bot['anti-bot-q'], $bot['anti-email'])) {
                    $captchaGood = true;
                } else {
                    $response = array('status' => 400, 'message' => $feedbackClass->errors, 'color' => 'red');
                }
            }
        }
        /* если все good то пропускаем на отправку */
        if (empty($feedbackClass->errors) && $captchaGood == true) {
            /* отправка в телеграм */
            $feedbackClass->sendTelegram($txt);
            /* отправка по smtp */
            try {
                if (empty($feedbackClass->errors) && $feedbackClass->send(Config::getValue('email'), Config::getValue('company_name'), $feedback['email'], $feedback['fullName'], $feedback['subject'], $htmlBody, $attachment)) {
                    $response = array(
                        'status' => 200, 'color' => 'green',
                        'message' => I18N::locale("Ваше сообщение успешно отправлено", "Sizning xabaringiz muvaffaqiyatli yuborildi", "Your message has been sent successfully")
                    );
                    $feedbackClass->insertMail($feedback['email'], $feedback['fullName'], $feedback['phone'], $feedback['subject'], $htmlBody);
                } else {
                    $response = array('status' => 400, 'message' => $feedbackClass->errors, 'color' => 'red');
                }
            } catch (\PHPMailer\PHPMailer\Exception $e) {
                $response = array('status' => 400, 'message' => $e->getMessage(), 'color' => 'red');
            }
        }
    } else {
        $response = array('status' => 400, 'message' => $feedbackClass->errors, 'color' => 'red');
    }


    return response()->json($response, \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => 'utf-8'], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES|JSON_PRETTY_PRINT)->send();
  

