<?php
require_once "../includes/visitor.inc.php";

use Mnv\Core\Config;
use Mnv\Core\Locale\I18N;
use Mnv\Core\Utilities\Cookie\Session;
use Mnv\Modules\Shop\Order;
use Mnv\Modules\Shop\Basket;
use Mnv\Core\Feedback;


global $smarty, $siteApp;
$result = null;

$feedbackClass = new Feedback(Config::getValue('mail_transport'));
$feedbackClass->getCaptchaEnabled(Config::getValue('feedback_captcha_enabled'));
$feedbackClass->getAllowCaptcha(Config::getValue('allow_recaptcha'));
$feedbackClass->telegram(Config::getValue('telegram_send'));

$htmlBody = '';
$error    = '';
$clientEmail = '';

$rewrite        = getRequestVar('rewrite');
$order          = getRequestVar('order', '', true);
$action         = getRequestVar('action');
$quantity       = (int) getRequestVar('quantity', 0);
$productId      = (int) getRequestVar('id', 0);

if ($rewrite != Config::getValue('rewrite')) {
    header("HTTP/1.0 301 Moved Permanently");
    header("Location: " . SITE_URL);

    /* saving visit */
    writeErrorVisit(301);
    exit;
}

$orderClass = new Order();

/* checking whether message is empty */
$order['contact'] = preg_replace("/(%0A|%0D|\n|\r)/i", '', trim($order['contact']));
if (empty($order['contact'])) $orderClass->errors[] = 'contact';

//print_r($order);

if ($action === 'order' && empty($orderClass->errors)) {

    if (!empty($productId)) {

        if ($siteApp->add_to_basket($productId, $quantity)) {
            $siteApp->success = 'Product added to cart!';
        } else {
            $siteApp->errors = 'Product not added to cart!';
        }

        $cart = new Basket();

        $cart->getBasket();
        if (!empty($cart->basket)) {
            $order['payment_method'] = 'cash';
            $order['message'] = '';
            if ($orderClass->insertOneClickOrder($order, $cart->basket)) {

                $orderClass->getOrder($orderClass->orderId);

                $arrayMessage = array_filter([
                    'Дата отправки сообщения' => adjustTime(gmdate('d-m-Y H:i'), false, 'd-m-Y H:i'),
                    'Ф.И.О.'        => $orderClass->order->client->fullName,
                    'Контакт'       => $orderClass->order->client->contact,
                    'Адрес'         => $orderClass->order->client->address,
                    'Сообщение'     => $orderClass->order->message,
                    'Кол-во'        => $orderClass->order->quantity,
                    'Общая сумма'   => number_format($orderClass->order->amount, "0", ".", " ") . ' сум',
                    'Список товаров'     => '========================================='

                ]);

                $txt = "<b> Заказ № " . $orderClass->orderId . "</b>%0A";
                foreach($arrayMessage as $key => $value) {
                    $txt .= "<b>".$key.":</b> ".$value."%0A";
                }
                foreach ($orderClass->order->products as $productId => $product) {
                    $txt .= "№ " . ($productId + 1) ." %0A";
                    $txt .= "<b>ID товара</b>: " . $product->articleId ." %0A";
                    $txt .= "<b>Наименование</b>: ".$product->title."%0A";
                    $txt .= "<b>Цена</b>: " . number_format($product->price, "0", ".", " ") ."сум %0A";
                    $txt .= "<b>Кол-во</b>: ".$product->quantity."%0A";
                    $txt .= "<b>Цена за кол-во</b>: " . number_format($product->amount, "0", ".", " ") ."сум %0A";
                }

                $feedbackClass->sendTelegram($txt);

                $smarty->assign('order', $orderClass->order);
                $htmlBody = $smarty->fetch('mail/order.tpl');

                if ($feedbackClass->send(Config::getValue('email'), Config::getValue('company_name'), null, null, 'Заказ № ' . $orderClass->orderId, $htmlBody)) {

                    if (Session::has('token')) Session::delete('token');
                    if (Session::has('basket')) Session::delete('basket');

                    $contact = $feedbackClass->maskPhone($order['contact']);
                    $orderClass->response = array('status' => 200, 'color' => 'green',
                        'message' => I18N::locale(
                            "Ваш заявка принята, наш менеджер свяжется с Вами по указанному контакту $contact",
                            "Sizning arizangiz qabul qilinadi, menejeringiz siz bilan $contact bilan bog'lanish uchun sizga murojaat qiladi",
                            "Your application has been accepted, our manager will contact you at the specified contact $contact"
                        ));
                } else {
                    $orderClass->response = array('status' => 400, 'color' => 'red',
                        'message' => I18N::locale("Ошибка при при отправке заказа", "Buyurtmani yuborishda xatolik yuz berdi", "Error when sending an order"));
                }

            } else {
                $orderClass->response = array('status' => 400, 'color' => 'red',
                    'message' => I18N::locale("Ошибка обновление данных при оформление", "Yuborilgan ma'lumotlar bo'sh bo'lmasligi kerak", "The data sent should not be empty"));
            }
        } else {
            $orderClass->response = array('status' => 400, 'color' => 'red',
                'message' => I18N::locale("Пустая корзина", "Yuborilgan ma'lumotlar bo'sh bo'lmasligi kerak", "The data sent should not be empty"));
        }
    } else {

        $orderClass->response = array('status' => 400, 'color' => 'red', 'errors' => array('payment'),
            'message' => I18N::locale("Произошла ошибка в работе скрипта, обновите пожалуйста страницу и повторите", "To'lov usulini tanlang", "Choose a payment method")
        );
    }
} else {
    $orderClass->response = array('status' => 400, 'color' => 'red', 'errors' => $orderClass->errors,
        'message' => I18N::locale("Необходимо заполнить все поля помеченные звездочкой", "To'lov usulini tanlang", "Choose a payment method")
    );
}



return response()->json($orderClass->response, \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => 'utf-8'], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES|JSON_PRETTY_PRINT)->send();