<?php

use Mnv\Core\Config;
use Mnv\Core\DB;

require_once('../includes/visitor.inc.php');
	
	$fileName  = getRequestVar('fileName');
	$page      = (int) getRequestVar('page');
	$rewrite   = getRequestVar('rewrite');
	$nocache   = (boolean) getRequestVar('nocache');
	
	//print_r($page);

	if ($brand = DB::init()->connect()->table('brands')->where('fileName', '=', $fileName)->get()) {
		/* checking whether we in rewrite mode */
		if ($rewrite != Config::getValue('rewrite')) {
			header("HTTP/1.0 301 Moved Permanently");
			header("Location: $brand->url");

			/* saving visit */
			writeErrorVisit(301);
			exit;
		}

		$templateName = empty($brand->templateName) ? 'brand.tpl' : $brand->templateName;

		if (!$smarty->isCached($templateName, md5($fileName).SITE_LANG_POSTFIX)) {
			/* displaying brand */
			//$brand = prepareBrand($brand);
			$smarty->assign('brand', $brand);
			
		}
		
		if ($page < 1) $page = 1;
        $smarty->assign('page', $page);	
            
		//$smarty->display($templateName, md5($fileName).SITE_LANG_POSTFIX);
		$smarty->display($templateName, "$fileName-$page".SITE_LANG_POSTFIX);

		/* precise load time */
//		updateLoadTime();
	}  else {

		/* article not found */
		header("HTTP/1.0 404 Not Found");

		/* finding URI part, that caused 404 error */
		$requestUri = strtolower(urldecode($_SERVER['REQUEST_URI']));
		$parsedUrl  = parse_url(strtolower(SITE_URL));
		print_r($requestUri);
		$errorUrl   = @str_replace($parsedUrl['path'], '', $requestUri);

		/* finding all words in the URL */
		if(preg_match_all("/[a-zA-Z0-9]+/", $errorUrl, $matches)) $query = implode(' ', $matches[0]);
		if(!empty($query)) $smarty->assign('query', $query);

		/* saving visit */
		writeErrorVisit(404);
		
		$smarty->display('error-404.tpl', md5($fileName).SITE_LANG_POSTFIX);

		/* precise load time */
		//updateLoadTime();
	}