<?php

use Mnv\Core\Config;
use Mnv\Models\Users\UserFactory;

require_once '../includes/visitor.inc.php';


	$sectionId 	= (int) getRequestVar('sectionId');
	$page      	= (int) getRequestVar('page');
	$rewrite   	= getRequestVar('rewrite');
	$topMenu    = getRequestVar('topMenu');
    $action     = getRequestVar('action');

    $query      = getRequestVar('query');
    $type       = getRequestVar('type');
    $sort_by    = getRequestVar('sort_by', null);
    $brands     = (string)getRequestVar('brands', null);
    $min_price  = getRequestVar('min_price', '');
    $max_price  = getRequestVar('max_price', '');
    $special    = (string)getRequestVar('special', null);

    if (!empty($SECTIONS[$sectionId])) {
		$section = prepareSection($SECTIONS[$sectionId]);
//        print_r($section);

		$smarty->assign('section', $section);

	} else {
		header("HTTP/1.0 301 Moved Permanently");
		header("Location: ".SITE_URL."/");

		/* saving visit */
		writeErrorVisit(301);
		exit;
	}

	/* checking whether we in rewrite mode */
	if ($rewrite != Config::getValue('rewrite')) {
		header("HTTP/1.0 301 Moved Permanently");
		header("Location: $section->url");

		/* saving visit */
		writeErrorVisit(301);
		exit;
	}

	/* caching procedures */
	if ($section->isCached == 1) {
		$smarty->caching( 2, $section->cacheTime * $section->cachePeriod);
	} elseif ($section->isCached != -1 && Config::getValue('cache_enabled_section') == 1) {
		$smarty->caching = 2;
        $smarty->caching( 2, Config::getValue('cache_time_section') * Config::getValue('cache_period_section'));
	}

	if ($page < 1) $page = 1;
    $smarty->assign('page', $page);

	/* for "you-are-here" navigation */
	$sectionParents = getSectionParents($sectionId);
	$section->parent = getSectionParent($section->parentId);

	$smarty->assign('sectionParents', $sectionParents);
	$smarty->assign('activeSection', $SECTIONS[$sectionId]);
	$smarty->assign('query', $query);
	$smarty->assign('type', $type);

	$smarty->assign('brands', $brands);
    $smarty->assign('special', $special);
    $smarty->assign('min_price', $min_price);
    $smarty->assign('max_price', $max_price);
	$smarty->assign('sort_by', $sort_by);

	/* saving visit */
	writeSectionVisit($sectionId, $page);

    $templateName = empty($section->templateName) ? ($section->type == 'tree' ? 'section.tpl' : 'page.tpl') : $section->templateName;
	$smarty->display($templateName, "$sectionId-$page".SITE_LANG_POSTFIX);

	/* precise load time */
	updateLoadTime();

?>