export const common = () => {
    function init100vh() {
        function setHeight() {
            var vh = window.innerHeight * 0.01
            document.documentElement.style.setProperty('--vh', `${vh}px`)
        }

        setHeight()
        window.addEventListener('resize', setHeight)
    }

    init100vh()

    function getRandomInt(min, max) {
        min = Math.ceil(min)
        max = Math.floor(max)
        return Math.floor(Math.random() * (max - min + 1)) + min
    }

    const partnersCardsContainer = document.querySelector('.partners-cards_js')

    if (partnersCardsContainer) {
        const partnersCardsArr = partnersCardsContainer.querySelectorAll('.partners-card_js')

        for (let index = 0; index < partnersCardsArr.length; index++) {
            const card = partnersCardsArr[index]

            let numberChild = card.children.length - 1
            var randomNum

            setInterval(() => {
                randomNum = getRandomInt(0, numberChild)

                for (let index = 0; index < card.children.length; index++) {
                    const cardImg = card.children[index]

                    if (randomNum == index) {
                        cardImg.classList.add('active')

                        cardImg.style.display = 'flex'
                        cardImg.style.opacity = '0'
                        cardImg.style.transition = '0 all ease'

                        setTimeout(() => {
                            cardImg.style.transition = '1s all ease'
                            cardImg.style.opacity = '1'
                        }, 100)
                    } else {
                        cardImg.classList.remove('active')
                        cardImg.style.display = 'none'
                    }
                }
            }, 3000)
        }
    }
}

export const addSelectorOnes = (el, selector) => {
    el.classList.add(selector)
}

export const removeSelectorOnes = (el, selector) => {
    el.classList.remove(selector)
}

export const removeSelectorInArr = (arrNode, selector) => {
    arrNode.forEach((arr) => {
        arr.forEach((element) => {
            element.classList.remove(selector)
        })
    })
}
