export const animFade = (item, durEnd) => {
    Object.assign(item.style, {
        display: 'flex',
        transition: '0s all ease',
        opacity: '0',
    })
    setTimeout(() => {
        Object.assign(item.style, {
            transition: `${durEnd}s all ease`,
            opacity: '1',
        })
    }, 0)
}

export const animFadeUp = (item, durEnd) => {
    Object.assign(item.style, {
        display: 'flex',
        transition: '0s all ease',
        opacity: '0',
        transform: 'translateY(100px)',
    })
    setTimeout(() => {
        Object.assign(item.style, {
            transition: `${durEnd}s all ease`,
            opacity: '1',
            transform: 'translateY(0)',
        })
    }, 0)
}

export const animFadeDown = (item, durEnd) => {
    Object.assign(item.style, {
        transition: '0s all ease',
        opacity: '0',
        transform: 'translateY(-100%)',
    })
    setTimeout(() => {
        Object.assign(item.style, {
            transition: `${durEnd}s all ease`,
            opacity: '1',
            transform: 'translateY(0)',
        })
    }, 0)
}

export const animFadeLeft = (item, durEnd) => {
    Object.assign(item.style, {
        transition: '0s all ease',
        opacity: '0',
        transform: 'translateX(-100%)',
    })
    setTimeout(() => {
        Object.assign(item.style, {
            transition: `${durEnd}s all ease`,
            opacity: '1',
            transform: 'translateX(0)',
        })
    }, 0)
}

export const animScale = (item, durEnd) => {
    Object.assign(item.style, {
        transition: '0s all ease',
        opacity: '0',
        transform: 'scale(0.9)',
    })
    setTimeout(() => {
        Object.assign(item.style, {
            transition: `${durEnd}s all ease`,
            opacity: '1',
            transform: 'scale(1)',
        })
    }, 0)
}
