export const map = () => { 
    var polygonOptions = {
        strokeColor: "#000",
        fillColor: "#515151",
        interactivityModel: "default#transparent",
        strokeWidth: 4,
        opacity: 0.7,
    };

    var canvasOptions = {
        strokeStyle: "#000",
        lineWidth: 4,
        opacity: 0.7,
    };

    async function fetchMoviesJSON(fileName) {
        const response = await fetch(fileName);
        const objMarkJson = await response.json();

        return objMarkJson;
    }

    fetchMoviesJSON("https://rieltor.lifestyle.uz/themes/assets/js/new_filter.json").then((objMarkFilterJson) => {
        testVar = objMarkFilterJson;
    });
    fetchMoviesJSON("https://rieltor.lifestyle.uz/objects").then((objMarkFilterJson2) => {
        console.log(objMarkFilterJson2);
    });

    fetchMoviesJSON("https://rieltor.lifestyle.uz/themes/assets/js/new.json").then((objMarkJson) => {
        for (let index = 0; index < objMarkJson.features.length; index++) {
            const element = objMarkJson.features[index];
            const element2 = testVar.properties[index];

            element.properties = element2;
        }

        console.log(objMarkJson);
    });

    ymaps.ready(["Map", "Polygon"]).then(function () {
        var map = new ymaps.Map(
                "map",
                {
                    center: [41.317648, 69.230585],
                    zoom: 12,
                },
                {
                    searchControlProvider: "yandex#search",

                    float: "left",
                }
            ),
            objectManager = new ymaps.ObjectManager({
                clusterize: true,

                gridSize: 90,
                minClusterSize: 2,
                clusterDisableClickZoom: true,
            });

        map.geoObjects.add(objectManager);

        window.firstStateArrObj = [];

        // objects and their options
        objectManager.objects.options.set({
            preset: "islands#blackCircleIcon",
            hasBalloon: false,
        });

        objectManager.objects.events.add("click", (e) => {
            let objectId = e.get("objectId");
            let coord = objectManager.objects.getById(objectId).geometry.coordinates;

            let objectIdBefore = e.get("objectId");

            if (objectIdBefore != "") {
                objectManager.objects.setObjectOptions(objectIdBefore, {
                    preset: "islands#greenCircleIcon",
                });

                objectIdBefore = "";
            }

            objectManager.objects.events.add("click", (e) => {
                if (objectIdBefore == "") {
                    objectManager.objects.setObjectOptions(objectId, {
                        preset: "islands#greyCircleIcon",
                    });
                }
            });
        });
        // objects and their options END

        // clusters and their options
        objectManager.clusters.options.set("preset", "islands#blackClusterIcons");

        objectManager.clusters.options.set("hasBalloon", false);
        objectManager.clusters.options.set("hintContent", false);

        objectManager.clusters.events.add("click", (e) => {
            let objectId = e.get("objectId");
            let coord = objectManager.clusters.getById(objectId).geometry.coordinates;
        });
        // clusters and their options END

        // poligon custom
        var polygon = null;
        var drawButton = document.querySelector("#draw");
        var drawButtonCancel = document.querySelector("#draw-cancel");

        drawButton.onclick = function () {
            drawButton.classList.add("active");
            drawButton.disabled = true;

            drawLineOverMap(map).then(function (coordinates) {
                coordinates = coordinates.filter(function (_, index) {
                    return index % 3 === 0;
                });

                if (polygon) {
                    map.geoObjects.remove(polygon);
                    objectManager.add(firstStateArrObj);
                }

                polygon = new ymaps.Polygon([coordinates], {}, polygonOptions);
                map.geoObjects.add(polygon);

                drawButton.classList.remove("active");
                drawButton.disabled = false;

                var result = ymaps.geoQuery(objectManager.objects).searchInside(polygon.geometry);

                result.then(function () {
                    let cordObjInside = result._objects,
                        trueArr = firstStateArrObj.filter((e) => cordObjInside.findIndex((i) => i.properties._data.price == e.properties.price) === -1);

                    objectManager.remove(trueArr);
                });

                drawButtonCancel.onclick = function () {
                    drawButton.classList.remove("active");
                    drawButton.disabled = false;

                    objectManager.add(firstStateArrObj);

                    if (polygon) {
                        map.geoObjects.remove(polygon);
                    }
                };
            });
        };

        function drawLineOverMap(map) {
            var canvas = document.querySelector("#draw-canvas");
            var ctx2d = canvas.getContext("2d");
            var drawing = false;
            var coordinates = [];
            var offsets = [];

            // Задаем размеры канвасу как у карты.
            var rect = map.container.getParentElement().getBoundingClientRect();
            canvas.style.width = rect.width + "px";
            canvas.style.height = rect.height + "px";
            canvas.width = rect.width;
            canvas.height = rect.height;

            // Применяем стили.
            ctx2d.strokeStyle = canvasOptions.strokeStyle;
            ctx2d.lineWidth = canvasOptions.lineWidth;
            canvas.style.opacity = canvasOptions.opacity;

            ctx2d.clearRect(0, 0, canvas.width, canvas.height);

            // Показываем канвас. Он будет сверху карты из-за position: absolute.
            canvas.style.display = "block";

            canvas.onmousedown = function (e) {
                // При нажатии мыши запоминаем, что мы начали рисовать и координаты.
                drawing = true;
                coordinates.push([e.pageX, e.pageY]);
                offsets.push([e.offsetX, e.offsetY]);
            };

            canvas.onmousemove = function (e) {
                // При движении мыши запоминаем координаты и рисуем линию.
                if (drawing) {
                    var last = offsets[offsets.length - 1];
                    ctx2d.beginPath();
                    ctx2d.moveTo(last[0], last[1]);
                    ctx2d.lineTo(e.offsetX, e.offsetY);
                    ctx2d.stroke();

                    coordinates.push([e.pageX, e.pageY]);
                    offsets.push([e.offsetX, e.offsetY]);
                }
            };

            return new Promise(function (resolve) {
                // При отпускании мыши запоминаем координаты и скрываем канвас.
                canvas.onmouseup = function (e) {
                    coordinates.push([e.pageX, e.pageY]);
                    canvas.style.display = "none";
                    drawing = false;

                    var projection = map.options.get("projection");
                    coordinates = coordinates.map(function (x) {
                        return projection.fromGlobalPixels(map.converter.pageToGlobal([x[0], x[1]]), map.getZoom());
                    });

                    resolve(coordinates);
                };
            });
        }
        // poligon custom END

        // regions area
        fetchMoviesJSON("https://rieltor.lifestyle.uz/themes/assets/js/area.json").then((objAreaJson) => {
            var polygonOptionsArea = {
                strokeColor: "#2e86de",
                fillMethod: "stretch",
                strokeWidth: 1,
                fillColor: "#2e86de",
                fillOpacity: 0.3,
            };

            const selectArea = document.querySelector(".select-map-area_js");
            var areaPoligon = null;

            selectArea.addEventListener("click", (e) => {
                let target = e.target.closest("li");

                if (target) {
                    if (!target.classList.contains("active") && target.getAttribute("data-value") > 0) {
                        let objArea = objAreaJson.regions.map((x) => x.subject.filter((x) => x.name.includes(target.textContent))),
                            arrAreas = objArea[0].map((x) => x.cords);

                        arrCord(arrAreas[0]);

                        if (areaPoligon) {
                            map.geoObjects.remove(areaPoligon);
                            objectManager.add(firstStateArrObj);
                        }

                        areaPoligon = new ymaps.Polygon([arrCord(arrAreas[0])], {}, polygonOptionsArea);
                        map.geoObjects.add(areaPoligon);

                        var resultArea = ymaps.geoQuery(objectManager.objects).searchInside(areaPoligon.geometry);

                        resultArea.then(function () {
                            let cordObjInside = resultArea._objects,
                                trueArr = firstStateArrObj.filter((e) => cordObjInside.findIndex((i) => i.properties._data.price == e.properties.price) === -1);

                            objectManager.remove(trueArr);
                            resultArea.applyBoundsToMap(map);
                        });
                    } else {
                        map.geoObjects.remove(areaPoligon);
                        objectManager.add(firstStateArrObj);
                    }
                }
            });
        });

        function arrCord(argArr) {
            var arrTest = [];

            argArr.forEach((arr) => {
                arrTest.push(arr.splice(0, 2, arr[1], arr[0]));
            });

            return arrTest;
        }
        // regions area END

        // object handler
        var roomNum = 0;
        var priceBefore = 0;
        var priceAfater = 0;

        const mapFilter = document.querySelector(".map-filter_js");

        if (mapFilter) {
            const filterRoomBtnNode = mapFilter.querySelectorAll(".map-filter-btn_js");

            mapFilter.addEventListener("click", (e) => {
                let target = e.target.closest(".map-filter-btn_js");

                if (target) {
                    if (!target.classList.contains("active")) {
                        filterRoomBtnNode.forEach((element) => {
                            element.classList.remove("active");
                        });

                        target.classList.add("active");
                        roomNum = Number(target.getAttribute("data-room"));

                        if (priceAfater <= 0) {
                            priceAfater = 99999999999999;
                        }

                        objectManager.setFilter(`properties.room == "${roomNum}" && properties.price >= "${priceBefore}" && properties.price <= "${priceAfater}"`);

                        if (roomNum == 0) {
                            roomNum = 0;
                            objectManager.setFilter(`properties.room > "${roomNum}" && properties.price >= "${priceBefore}" && properties.price <= "${priceAfater}"`);
                        }
                    }
                }
            });
        }

        const inputPriceNode = document.querySelectorAll(".input-price_js");

        if (inputPriceNode[0]) {
            for (let index = 0; index < inputPriceNode.length; index++) {
                const inputPrice = inputPriceNode[index];

                inputPrice.addEventListener("input", (e) => {
                    priceBefore = Number(inputPriceNode[0].value);
                    priceAfater = Number(inputPriceNode[1].value);

                    if (priceAfater <= 0) {
                        priceAfater = 99999999999999;
                    }

                    if (roomNum == 0) {
                        objectManager.setFilter(`properties.room > "${roomNum}" && properties.price >= "${priceBefore}" && properties.price <= "${priceAfater}"`);
                    } else {
                        objectManager.setFilter(`properties.room == "${roomNum}" && properties.price >= "${priceBefore}" && properties.price <= "${priceAfater}"`);
                    }
                });
            }
        }
        // object handler END

        window.testVar = [];
        fetchMoviesJSON("https://rieltor.lifestyle.uz/themes/assets/js/new_filter.json").then((objMarkFilterJson) => {
            testVar = objMarkFilterJson;
        });
        fetchMoviesJSON("https://rieltor.lifestyle.uz/objects").then((objMarkFilterJson2) => {
            console.log(objMarkFilterJson2);
        });

        fetchMoviesJSON("https://rieltor.lifestyle.uz/themes/assets/js/new.json").then((objMarkJson) => {
            for (let index = 0; index < objMarkJson.features.length; index++) {
                const element = objMarkJson.features[index];
                const element2 = testVar.properties[index];

                element.properties = element2;
            }

            objectManager.add(objMarkJson);
            firstStateArrObj = objectManager.objects.getAll();
        });
    });
 }
