export const forAjax = () => {
    function ajaxForm(params) {
        document.addEventListener('click', (e) => {
            let target = e.target.closest('.valid-btn_js')

            if (target) {
                let targetAttr = target.getAttribute('data-valid')

                if (targetAttr) {
                    if (target.closest(`${params.formId}`)) {
                        if (params.formId === '#feedback') {
                            var feedbackForm = $('#feedback');
                            cratePreloader(target.closest(`${params.formId}`));
                            $.post(feedbackForm.attr('action'), feedbackForm.serialize(), function (response) {
                                console.log(response);
                                if (response.status === 200) {
                                    // $('.notification').text(response.message).css('display', 'flex');
                                    succesPreloader('.form__preloader-round', '.form__preloader', response.message, response.color)

                                    setTimeout(() => {
                                        removePreloader('.form__preloader', `${params.formId}`);
                                    }, 3000)
                                } else {
                                    $('.notification').text(response.message).css('display', 'flex');
                                }
                            });
                        }

                        if (params.formId === '#vacancy') {

                            var vacancyForm = $('#vacancy');
                            const formData = new FormData(document.getElementById('vacancy'));
                            // const file = $('#loaded')[0].files[0];

                            // console.log(file.size)
                            // console.log(formData);

                                $.ajax({
                                    url: vacancyForm.attr('action'),
                                    type: vacancyForm.attr('method'),
                                    data: formData,
                                    contentType: false,
                                    processData: false,
                                    beforeSend: function() {
                                        cratePreloader(target.closest(`${params.formId}`));
                                    },
                                    success: function(response) {
                                        console.log(response);
                                        // $('.notification-vacancy').text(response.message).css('display', 'flex');
                                        succesPreloader('.form__preloader-round', '.form__preloader', response.message, response.color)
                                          
										setTimeout(() => {
                                            removePreloader('.form__preloader', `${params.formId}`);
                                        }, 3000)
                                    },
                                    error: function(xhr) {
                                        console.log(xhr.statusText + xhr.responseText);
                                        removePreloader('.form__preloader');
                                    },
                                    complete: function() {
                                        console.log('complete');
                                        // removePreloader('.form__preloader');
                                    },
                                });

                        }
                    }
                }
            }
        })
    }

    ajaxForm({
        formId: '#feedback',
    })

    ajaxForm({
        formId: '#vacancy',
    })
	
	 
	
	 function cratePreloader(parent ) {
        let createWrapper = document.createElement('div')
        let createRound = document.createElement('div')
        createWrapper.classList.add('form__preloader')
        createRound.classList.add('form__preloader-round')

        createWrapper.insertAdjacentElement('beforeend', createRound)
        parent.insertAdjacentElement('beforeend', createWrapper)

        createWrapper.style.display = 'flex'
        createWrapper.style.opacity = '0'
        createWrapper.style.transition = '0s all ease'
        

        setTimeout(() => {
            createWrapper.style.opacity = '1'
            createWrapper.style.transition = '0.3s all ease'
        }, 0)
    }
	
	function succesPreloader(ele, perent, txt, colorEl) {
        document.querySelector(ele).style.opacity = '0'
		document.querySelector(perent).style.color = `${colorEl}`
        document.querySelector(perent).textContent = txt
    }
	
 
     function removePreloader(selector, form) {
        let createWrapper = document.querySelector(selector)
        createWrapper.remove()

        let formEl = document.querySelector(form)
        let formInput = formEl.querySelectorAll('.valid-field_js')

        formInput.forEach((element) => {
            element.value = ''
        })
    }
}
