export const header = () => {
    function scrollHeader(item, itemInside) {
        var oldPosition = 0

        window.addEventListener('scroll', (e) => {
            if (!item.classList.contains('active')) {
                let currentPosition = document.documentElement.scrollTop

                if (oldPosition > currentPosition) {
                    item.classList.remove('transform')
                    item.classList.add('transform-show')
                } else {
                    item.classList.add('transform')
                    item.classList.remove('transform-show')
                }

                if (oldPosition <= 200) {
                    item.classList.remove('transform-show')
                }
                oldPosition = currentPosition
            }
        })
    }

    if (window.innerWidth >= 1170) {
        const header = document.querySelector('.header_js')
        scrollHeader(header)
    }

    const mobileMenu = document.querySelector('.mobile_js')
    const body = document.querySelector('body')

    if (mobileMenu) {
        document.addEventListener('click', (e) => {
            let target = e.target.closest('.burger-btn_js')

            if (target) {
                mobileMenu.classList.toggle('active')
                target.classList.toggle('active')

                body.style.overflow = body.style.overflow === 'hidden' ? 'auto' : 'hidden'
            }
        })
    }
}
