export const modal = () => {
    function modalHendler(params) {
        document.addEventListener('click', (e) => {
            let target = e.target.closest(params.selector)

            if (target) {
                let attr = target.getAttribute('data-src')

                if (attr) {
                    target.classList.add('data-fancybox')
                    params.src = attr

                    params.type = attr.includes('youtub') ? 'frame' : 'image'
                } else {
                    params.type = 'inline'
                    params.src = target.getAttribute('data-id')
                }

                const fancybox = new Fancybox([
                    {
                        src: params.src,
                        type: params.type,
                        autoFocus: false,
                    },
                ])
            }
        })
    }

    modalHendler({
        selector: '.modal-call_js',
        src: '#modalForm',
    })
}
