const contacts = document.querySelector('.contacts_js')

if (contacts) {
    function _contactAcard(arrBtn, ArrDrop, childBtn, childDrop) {
        for (let index = 0; index < arrBtn.length; index++) {
            const btn = arrBtn[index]
            const drop = ArrDrop[index]

            btn.addEventListener('click', (e) => {
                if (btn.classList.contains('active')) {
                    _removeSelectorInArr([arrBtn, ArrDrop, childBtn, childDrop], 'active')

                    arrBtn.forEach((element) => {
                        element.parentElement.classList.remove('active')
                    })
                } else {
                    _removeSelectorInArr([arrBtn, ArrDrop, childBtn, childDrop], 'active')
                    arrBtn.forEach((element) => {
                        element.parentElement.classList.remove('active')
                    })

                    btn.classList.toggle('active')
                    btn.parentElement.classList.toggle('active')
                    drop.classList.toggle('active')
                }
            })
        }
    }

    function _contactAcardInner(arrBtn, ArrDrop, parentEl) {
        for (let index = 0; index < arrBtn.length; index++) {
            const btn = arrBtn[index]
            const drop = ArrDrop[index]

            btn.addEventListener('click', (e) => {
                if (btn.classList.contains('active')) {
                    _removeSelectorInArr([arrBtn, ArrDrop], 'active')
                } else {
                    _removeSelectorInArr([arrBtn, ArrDrop], 'active')

                    btn.classList.toggle('active')
                    drop.classList.toggle('active')
                }
            })
        }
    }

    function _removeSelectorInArr(arrNode, selector) {
        arrNode.forEach((arr) => {
            arr.forEach((element) => {
                element.classList.remove(selector)
            })
        })
    }

    let contactsBtnCityArr = contacts.querySelectorAll('.contacts-btn-city_js'),
        contactsDropCityArr = contacts.querySelectorAll('.contacts-drop-city_js'),
        contactsBtnAreaArr = contacts.querySelectorAll('.contacts-area-btn_js'),
        contactsDropAreaArr = contacts.querySelectorAll('.contacts-area-drop_js')

    _contactAcard(contactsBtnCityArr, contactsDropCityArr, contactsBtnAreaArr, contactsDropAreaArr)
    _contactAcardInner(contactsBtnAreaArr, contactsDropAreaArr, '.contacts-drop-city_js')

    ymaps.ready(init)
    var myMap

    function init() {
        const mapAreaBtns = document.querySelectorAll('.contacts-area-btn_js')

        let startPos = mapAreaBtns[0].getAttribute('data-cord').split(',')

        ;(myMap = new ymaps.Map(
            'map',
            {
                center: [startPos[0], startPos[1]],
                zoom: 5,
                controls: [],
            },

            {
                suppressMapOpenBlock: true,
            }
        )),
            (myGeoObject = new ymaps.GeoObject())

        for (let index = 0; index < mapAreaBtns.length; index++) {
            const btn = mapAreaBtns[index]

            let btnCord = btn.getAttribute('data-cord')
            let arrCord = btnCord.split(',')

            myMap.geoObjects.add(myGeoObject).add(
                new ymaps.Placemark(
                    arrCord,
                    {
                        balloonContent: '',
                    },
                    {
                        preset: 'islands#icon',
                        iconCaptionMaxWidth: '30',
                        iconColor: '#122faa',
                    }
                )
            )
        }

        document.addEventListener('click', (e) => {
            let targetCity = e.target.closest('.contacts-btn-city_js')
            let targetArea = e.target.closest('.contacts-area-btn_js')

            if (targetCity) {
                let btnCord = targetCity.getAttribute('data-cord')
                let arrCord = btnCord.split(',')

                setCenter(arrCord)
            }

            if (targetArea) {
                let btnCord = targetArea.getAttribute('data-cord')
                let arrCord = btnCord.split(',')

                setCenterArea(arrCord)
            }
        })

        function setCenter(lang) {
            myMap.setCenter(lang, 8, {})
        }

        function setCenterArea(lang) {
            myMap.setCenter(lang, 14, {})
        }
    }
}
