export const mapFelials = () => {
    const mapSvg = document.querySelector('.felials-svg_js')

    if (mapSvg) {
        const felialsMap = document.querySelector('.felials-map_js')
        let felialLinkArr = Array.from(mapSvg.querySelectorAll('.felials-svg-link_js')).filter((x) => x.classList.contains('active'))

        let mapSvgRect = _takeRect(mapSvg)

        for (let index = 0; index < felialLinkArr.length; index++) {
            let felialLink = felialLinkArr[index],
                locationcCircle = felialLink.querySelector('circle'),
                locationName = felialLink.querySelector('text'),
                locationImage = felialLink.querySelector('image')

            let locationPos = _locationPosition(locationcCircle, mapSvgRect.top, mapSvgRect.left)

            let felialInfoWrap = _createEl('felials__location-wrap'),
                felialList = _createEl('felials__city-list'),
                felialIcon = _createEl('felials__city-icon')

            let felialItemArr = Array.from(locationName.querySelectorAll('tspan')).map((x) => x)

            for (let index = 0; index < felialItemArr.length; index++) {
                const felialItem = felialItemArr[index]

                let felialItemCreate = _createEl('felials__city-item')
                felialItemCreate.textContent = felialItem.textContent

                _inserEl(felialList, felialItemCreate)
            }

            felialIcon.style.backgroundImage = `url(${locationImage.getAttributeNS('http://www.w3.org/1999/xlink', 'href')})`

            _inserEl(felialInfoWrap, felialList)
            _inserEl(felialsMap, felialInfoWrap)
            _inserEl(felialsMap, felialIcon)

            let felialInfoWrapRect = _takeRect(felialInfoWrap)
            let felialIconRect = _takeRect(felialIcon)

            _positionElement(felialInfoWrap, locationPos[0] - felialInfoWrapRect.height - felialIconRect.height - 16, locationPos[1] - felialInfoWrapRect.width / 2)
            _positionElement(felialIcon, locationPos[0] - felialIconRect.height, locationPos[1] - felialIconRect.width / 2)

            if (window.innerWidth > 768) {
                felialLink.addEventListener('mouseenter', () => felialInfoWrap.classList.add('active'))
                felialLink.addEventListener('mouseleave', () => felialInfoWrap.classList.remove('active'))
            }

            window.addEventListener('resize', () => {
                mapSvgRect = _takeRect(mapSvg)

                locationPos = _locationPosition(locationcCircle, mapSvgRect.top, mapSvgRect.left)

                felialInfoWrapRect = _takeRect(felialInfoWrap)
                felialIconRect = _takeRect(felialIcon)

                _positionElement(felialInfoWrap, locationPos[0] - felialInfoWrapRect.height - felialIconRect.height - 16, locationPos[1] - felialInfoWrapRect.width / 2)
                _positionElement(felialIcon, locationPos[0] - felialIconRect.height, locationPos[1] - felialIconRect.width / 2)
            })
        }
    }

    function _takeRect(el) {
        return el.getBoundingClientRect()
    }

    function _locationPosition(el, h, w) {
        let locationRect = el.getBoundingClientRect(),
            y = locationRect.top - h,
            x = locationRect.left - w

        return [y, x]
    }

    function _createEl(selector) {
        let nameEl = document.createElement('div')
        nameEl.classList.add(selector)

        return nameEl
    }

    function _inserEl(parent, child) {
        parent.insertAdjacentElement('beforeend', child)
    }

    function _positionElement(elem, x, y) {
        Object.assign(elem.style, {
            top: `${x}px`,
            left: `${y}px`,
        })
    }
}
