export const send = () => {
    const form = document.querySelector('.form_js')

    if (form) {
        let formItemNode = form.querySelectorAll('.form-item_js')
        let formTextNode = form.querySelectorAll('.text-result_js')

        let formItemArr = Array.from(formItemNode).map((x) => x)
        let formTextArr = Array.from(formTextNode).map((x) => x)

        let inputArr = formItemArr.map((x) => x.querySelectorAll('.input_js'))
        let textInputArr = formTextArr.map((x) => x.querySelectorAll('.input_js'))

        let selectArr = formItemArr.map((x) => x.querySelectorAll('.select_js'))
        let textSelectArr = formTextArr.map((x) => x.querySelectorAll('.select-text_js'))

        let checkboxArr = formItemArr.map((x) => x.querySelectorAll('.checkbox_js'))
        let checkboxTextArr = formTextArr.map((x) => x.querySelectorAll('.checkbox_js'))

        for (let index = 0; index < inputArr.length; index++) {
            const inputs = inputArr[index]
            const selects = selectArr[index]

            const textInputs = textInputArr[index]
            const textSelects = textSelectArr[index]

            for (let index = 0; index < inputs.length; index++) {
                const input = inputs[index]
                const textInput = textInputs[index]

                input.addEventListener('input', () => {
                    textInput.textContent = input.value
                })
            }

            for (let index = 0; index < selects.length; index++) {
                const select = selects[index]
                const textSelect = textSelects[index]

                let selectDropItemNode = select.querySelectorAll('.select-btn_js')

                for (let index = 0; index < selectDropItemNode.length; index++) {
                    const selectItem = selectDropItemNode[index]

                    selectItem.addEventListener('click', (e) => {
                        textSelect.textContent = selectItem.textContent
                    })
                }
            }

            for (let index = 0; index < checkboxArr.length; index++) {
                const checkboxs = checkboxArr[index]
                const checkboxTexts = checkboxTextArr[index]

                for (let index = 0; index < checkboxs.length; index++) {
                    const checkbox = checkboxs[index]
                    const checkboxText = checkboxTexts[index]

                    checkbox.addEventListener('input', () => {
                        if (checkbox.checked) {
                            checkboxText.classList.add('active')
                        } else {
                            checkboxText.classList.remove('active')
                        }
                    })
                }
            }
        }
    }
}
